<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class fo_other_activities extends Model
{
    protected $table = 'fo_other_activities';
    protected $primaryKey = 'id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'supplier_id',
        'employee_id',
        'description',
        'Date',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_other_activities";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
