<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class fo_supplier_visit extends Model
{
    protected $table = 'fo_supplier_visit';
    protected $primaryKey = 'supplier_visit_id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'supplier_visit_id',
        'employee_id',
        'supplier_id',
        'arrival',
        'arrival_status',
        'depature',
        'depature_status',
        'latitude',
        'longitude',
        'observation',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_supplier_visit";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

    // protected static function newFactory()
    // {
    //     return \Modules\Fo\Database\factories\FoSupplierVisitFactory::new();
    // }
}
