<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\PlanProduct;
use Modules\Fo\Entities\PlanProductEmployee;

class PlanProductListController extends Controller
{


    function getMainPlanList()
    {
        try {
            $mainPlanList = DB::select('SELECT DISTINCT fo_plan_products.plan_product_id = 0,hr_employee_sites.site_id,hr_employee_sites.site,fo_plan_products.`year`,fo_plan_products.`month` FROM fo_plan_products INNER JOIN hr_employee_sites ON fo_plan_products.site_id = hr_employee_sites.site_id ');

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "getMainPlanList", $mainPlanList);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "getMainPlanList", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function delete($site, $year, $month)
    {
        try {
            $planProducts = PlanProduct::where([['site_id', '=', $site], ['year', '=', $year], ['month', '=', $month]])->get();
            foreach ($planProducts as $planProduct) {
                PlanProductEmployee::where('plan_product_id', '=', $planProduct->plan_product_id)->delete();
                $planProduct->delete();
            }

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "delete", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "delete", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
