<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\St\Entities\Product;
use Modules\St\Entities\Suppliers;
class PlanVsActualController extends Controller
{
    function fieldOfficers()
    {
        try {
            $fieldOfficers = Employee::where([['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5'], ['designation_id', '=', '30']])->get();
            $responseBody = $this->responseBody(true, "PlanVsIntakeController", "fieldOfficers", $fieldOfficers);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanVsIntakeController", "fieldOfficers", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    function suppliers()
    {
        try {
            $fieldOfficers = Suppliers::all();
            $responseBody = $this->responseBody(true, "PlanVsIntakeController", "suppliers", $fieldOfficers);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanVsIntakeController", "suppliers", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function materials()
    {
        try {
            $products = Product::all();
            $responseBody = $this->responseBody(true, "PlanVsIntakeController", "materials", $products);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanVsIntakeController", "materials", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function visitPlanActualReport($search_option, $date_from, $date_to)
    {
        try {
            $search_option_aaray =  json_decode($search_option);
            $officer = $search_option_aaray->officer;
            $supplier = $search_option_aaray->supplier;
            $material = $search_option_aaray->material;

            $visit_plan_query = 'SELECT fo_plan_product_employee_dailies.date,
            st_suppliers.supplier_name,
            st_products.product_name,
            fo_plan_product_employee_dailies.quantity
            FROM fo_plan_product_employee_dailies 
            INNER JOIN st_suppliers ON fo_plan_product_employee_dailies.supplier_id = st_suppliers.supplier_id
            INNER JOIN st_products ON fo_plan_product_employee_dailies.product_primary_id = st_products.product_primary_id
            WHERE ';


            $visit_actual_query = 'SELECT DATE(fo_supplier_visit.arrival) AS date,
            st_suppliers.supplier_name
            FROM fo_supplier_visit 
            INNER JOIN st_suppliers ON fo_supplier_visit.supplier_id = st_suppliers.supplier_id
            WHERE ';

            if ($officer != '') {
                $visit_plan_query .= "fo_plan_product_employee_dailies.field_officer_id = '" . $officer . "' AND ";
                $visit_actual_query .= "fo_supplier_visit.employee_id = '" . $officer . "' AND ";
            }

            if ($supplier != '') {
                $visit_plan_query .= "fo_plan_product_employee_dailies.supplier_id = '" . $supplier . "' AND ";
                $visit_actual_query .= "fo_supplier_visit.supplier_id = '" . $supplier . "' AND ";
            }

            if ($material != '') {
                $visit_plan_query .= "fo_plan_product_employee_dailies.product_primary_id = '" . $material . "' AND ";
            }
            $visit_plan_query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $visit_plan_query);
            $visit_actual_query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $visit_actual_query);

            $visit_plan_query .= " AND fo_plan_product_employee_dailies.`date`  BETWEEN '" . $date_from . "' AND '" . $date_to . "'";
            $visit_actual_query .= " AND DATE(fo_supplier_visit.arrival)  BETWEEN '" . $date_from . "' AND '" . $date_to . "'";


            $visit_plan_result = DB::select($visit_plan_query);
            $visit_actual_result = DB::select($visit_actual_query);

            $responseBody = $this->responseBody(true, "PlanVsIntakeController", "materials", ['visit_plan' => $visit_plan_result, 'visit_actual' => $visit_actual_result]);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanVsIntakeController", "materials", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }





    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
