<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Fo\Entities\SupplierMaterial;
use Illuminate\Support\Facades\DB;
use Modules\St\Entities\Product;

class SupplierMaterialController extends Controller
{
    // Get All Suppliers 
    function GetSuppliers() {
        try{$result = DB::table('st_suppliers')
            ->where('supplier_type_id',1)
            ->get();

            $responseBody = $this->responseBody(true, "Suppliers", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers", "Error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    // Get All Products 
    function GetProducts() {
        try{$result = Product::where('product_type_id','=',1)->get();

            $responseBody = $this->responseBody(true, "Products", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Products", "Error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    // Get Supplier Address 
    function GetSupplierAddress($id) {
        try{$address = DB::table('st_suppliers')->where('supplier_id', '=', $id)->get();
          
            $assignedProducts = DB::table('fo_supplier_materials')
            ->join('st_products', 'fo_supplier_materials.product_Id', '=', 'st_products.product_id')
            ->where('fo_supplier_materials.supplier_id', '=', $id)->get();


            $responseBody = $this->responseBody(true, "Supplier_Address", "Found", ["address" => $address, "assignedProducts" => $assignedProducts]);
                    
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier_Address", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    // To get assigned products to supplier 
    function GetNewlyAssignedProducts($id) {
        try{$result = DB::table('fo_supplier_materials')
            ->join('st_products', 'fo_supplier_materials.product_Id', '=', 'st_products.product_id')
            ->where('fo_supplier_materials.supplier_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "NewlyAssignedProducts", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "NewlyAssignedProducts", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody]);
    }

    // To get products asigned to the supplier 
    function GetSupplierAssignedProducts($id) {
        try{
            foreach ($id as $product_id) {
                $result = DB::table('st_products')->where('product_id', '=', $id)->get();
            }

            $responseBody = $this->responseBody(true, "ProductNames", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductNames", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    // Insert by dragging and dropping 
    function AssignProduct(Request $request) {
        try{$object = new SupplierMaterial;

            $object->product_Id = $request->get('data');
            $object->supplier_id = $request->get('supplier_id');

            $supplier_id = $object->supplier_id;

            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Product", "Assigned", $supplier_id);
            }

        } catch (\Exception $exception) {
                $responseBody = $this->responseBody(false, "Product", "Failed", $exception);
        }
        return response()->json([ "data" => $responseBody ]);
    }

    // Insert data by button 
    function InsertCheckedData(Request $request) {
        try{
            $data = $request->get('product_id');

            for ($i = 0; $i < sizeof($data); $i++) {

                $object [] = [
                    'supplier_id' => $data[$i]['supplier_id'],
                    'product_Id' => $data[$i]['product_id']
                ];                 
            }
            $save = SupplierMaterial::insert($object);
            
            if( $save) {
               $responseBody = $this->responseBody(true, "CheckedData", "Inserted", $object);
            } 
            
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CheckedData", "Error", $exception);
        }
        return response()->json([ "data" => $responseBody ]);   
    }

    // Delete product 
    function DeleteAssignProducts($id) {
        try {$object = SupplierMaterial::find($id);

            $delete = $object->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Products", "Deleted", null);
            }

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "products", "DeleteError", $exception);
        }

        return response()->json([ "data" => $responseBody ]);
    }



    function responseBody($success, $name, $message, $result) {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
