<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\PlanProductEmployeeDaily;
use Modules\Fo\Entities\SupplierVisitPlan;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\St\Entities\Product;
use Modules\St\Entities\Suppliers;

class SupplierVisitPlanController extends Controller
{




    function fieldOfficers()
    {
        try {
            $fieldOfficers = Employee::where([['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5'], ['designation_id', '=', '30']])->get();
            $responseBody = $this->responseBody(true, "SupplierVisitPlanController", "fieldOfficers", $fieldOfficers);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "SupplierVisitPlanController", "fieldOfficers", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }





    function save(Request $request)
    {
        try {
            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);
                $employee_id = $dd->employee_id;
                $year = $dd->year;
                $month = $dd->month;
                $supplier_id =  $dd->supplier_id;
                $date =  $dd->date;
                $visit_detail =  $dd->visit_detail;
                SupplierVisitPlan::where([['employee_id', '=', $employee_id], ['supplier_id', '=', $supplier_id], ['year', '=', $year], ['month', '=', $month],  ['visit_date', '=', $date]])->delete();
            }
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);
                $employee_id = $dd->employee_id;
                $year = $dd->year;
                $month = $dd->month;
                $supplier_id =  $dd->supplier_id;
                $date =  $dd->date;
                $visit_detail =  $dd->visit_detail;



                if ($dd->supplier_id != "null") {
                    $visitPlan = new SupplierVisitPlan();
                    $visitPlan->employee_id = $employee_id;
                    $visitPlan->year = $year;
                    $visitPlan->month = $month;
                    $visitPlan->supplier_id = $supplier_id;
                    $visitPlan->visit_date = $date;
                    $visitPlan->visit_detail = $visit_detail;
                    $visitPlan->save();
                }
            }
            $responseBody = $this->responseBody(true, "SupplierVisitPlanController", "save", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "SupplierVisitPlanController", "save", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')
                                    ->where('supplier_type_id',1)
                                    ->get();
            return $this->responseBody(true, "SupplierVisitPlanController", "allSuppliers", $products);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "SupplierVisitPlanController", "error", $exception);
        }
    }


    public function loadSavedSupplierVisitPlan($officer_id, $year, $month)
    {
        try {
            $query = 'SELECT fo_supplier_visit_plans.*,st_suppliers.supplier_name FROM fo_supplier_visit_plans INNER JOIN st_suppliers ON fo_supplier_visit_plans.supplier_id = st_suppliers.supplier_id WHERE employee_id = "' . $officer_id . '" AND year = "' . $year . '" AND month = "' . $month . '"';
            $products =  DB::select($query);
            $responseBody = $this->responseBody(true, "SupplierVisitPlanController", "loadSavedSupplierVisitPlan", $products);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "SupplierVisitPlanController", "loadSavedSupplierVisitPlan", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
