<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\EmployeeSupplyCollection;
use Modules\Hr\Entities\Employee;

class SupplyCollectionController extends Controller
{
    // Get All Suppliers
    function GetSuppliers()
    {
        try {
            $result = DB::table('st_suppliers')->get();

            $responseBody = $this->responseBody(true, "Suppliers", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers", "Error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    // Save supply collection
    function InsertSupplyCollection(Request $request)
    {
        try {
            $data = $request->get('all_data');

            for ($i = 0; $i < sizeof($data); $i++) {
                $object[] = [
                    'employee_id' => $data[$i]['employee_id'],
                    'supplier_id' => $data[$i]['supplier'],
                    'trans_date' => $data[$i]['date'],
                    'product_id' => $data[$i]['products'],
                    'collection_quantity' => $data[$i]['quantities']
                ];
            }
            $save = EmployeeSupplyCollection::insert($object);

            if ($save) {
                $responseBody = $this->responseBody(true, "SupplyCollection", "Found", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SupplyCollection", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    // get supplier collection data
    function GetSupplyCollectionData($id)
    {
        try {
            $result = DB::table('fo_employee_supply_collections')
                ->join('st_suppliers', 'fo_employee_supply_collections.supplier_id', '=', 'st_suppliers.supplier_id')
                ->where('fo_employee_supply_collections.employee_supply_collection_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "CollectionData", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CollectionData", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetProductsOnDateToSupplyCollection(Request $request)
    {
        try {
            $date = $request->get('date');
            $supplier = $request->get('supplier_id');

            $result = DB::table('fo_employee_supply_collections')
                ->join('st_products', 'fo_employee_supply_collections.product_id', '=', 'st_products.product_id')
                ->join('fo_employee_supply_plans', 'st_products.product_id', '=', 'fo_employee_supply_plans.product_id')
                ->where('fo_employee_supply_collections.supplier_id', '=', $supplier)
                ->where('fo_employee_supply_collections.trans_date', '=', $date)
                ->groupBy('fo_employee_supply_collections.product_id')
                ->get();

            $responseBody = $this->responseBody(true, "Products On Date", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Products On Date", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function UpdateSupplyCollection(Request $request)
    {
        try {
            foreach ($request->primary_ids as $key => $value) {
                $data = array(
                    'supplier_id' => $request->suppliers[$key],
                    'trans_date' => $request->dates[$key],
                    'product_id' => $request->products[$key],
                    'collection_quantity' => $request->quantities[$key],
                );
                $save = EmployeeSupplyCollection::where('employee_supply_collection_id', $request->primary_ids[$key])
                    ->update($data);
            }
            if ($save) {
                $responseBody = $this->responseBody(true, "Supply Collection", "Updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supply Collection", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetSupplierCollectionList($id, $start_date, $end_date)
    {
        try {
            /*$result = DB::table('fo_employee_supply_collections')
                ->join('st_suppliers', 'fo_employee_supply_collections.supplier_id', '=', 'st_suppliers.supplier_id')
                ->select('fo_employee_supply_collections.*', 'st_suppliers.supplier_name')
                ->groupBy('fo_employee_supply_collections.trans_date', 'fo_employee_supply_collections.supplier_id')->get();*/

            $query = "SELECT
                fo_employee_supply_collections.`employee_supply_collection_id` AS collection_id,
                st_suppliers.`supplier_name` AS supplier_name,
                st_suppliers.`supplier_id` AS supplier_id,
                fo_employee_supply_collections.`trans_date` AS trans_date
           FROM
                `fo_employee_supply_collections` fo_employee_supply_collections INNER JOIN `st_suppliers` st_suppliers ON fo_employee_supply_collections.`supplier_id` = st_suppliers.`supplier_id` WHERE fo_employee_supply_collections.`employee_id` = '" . $id . "' AND fo_employee_supply_collections.`trans_date` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";

            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "SupplyCollection", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SupplyCollection", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function LoadPlanToCollection($id)
    {
        try {
            $address = DB::table('st_suppliers')->where('supplier_id', '=', $id)->get();
            $products = DB::table('fo_employee_supply_plans')
                ->join('st_products', 'fo_employee_supply_plans.product_id', '=', 'st_products.product_id')
                ->where('fo_employee_supply_plans.supplier_id', '=', $id)
                ->groupBy('st_products.product_id')->get();

            $responseBody = $this->responseBody(true, "Employee Supply Plan To Collection", "Found", ["address" => $address, "products" => $products]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Supply Plan To Collection", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    // sampath //
    public function allFieldOfficer()
    {
        try {
            $field_officer = Employee::where('designation_id', '=', '30')->get();

            $field_officer_id = [];
            $field_officer_name = [];
            foreach ($field_officer as $officer) {
                array_push($field_officer_id, ["img" => $officer['photo_parth'], "id" => $officer['employee_id'], "value" => $officer['employee_id']]);
                array_push($field_officer_name, ["img" => $officer['photo_parth'], "id" => $officer['employee_id'], "value" => $officer['name_withinitial']]);
            }

            $responseBody = $this->responseBody(true, "FieldOfficer", "all", ["id" => $field_officer_id, "name" => $field_officer_name]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FieldOfficer", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getEmployeeByID($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function isFieldOfficer($id)
    {
        try {
            $employee = Employee::find($id);
            $bool = false;
            if ($employee->designation_id == '30') {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "FieldOfficer", "is_fieldOfficer", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FieldOfficer", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
