console.log('employeesupplierjs')
const SAVE = "save";
const UPDATE = "update";

const TITLE_MAP = {
    'savesupplier': 'Assign A New Supplier',
    'updatesupplier': 'Update Supplier',
};
$(document).ready(function() {

    $('#tblSupplier').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "supplier_id" },
            { "data": "supplier_name" },
            { "data": "address" },
            { "data": "delete", className: "delete"  },
        ],
    });



})
function GetSuppliersByEmployee(id) {

    $.ajax({
        type: 'GET',
        url: '/fo/EmployeeSupplier/getSuppliersByEmployee/' + id,
        success: function(response) {
            console.log(response);

            if (response.data.success) {
                var employee_id = response.data.result[0]['employee_id'];
                $('#hidEmployeeID').val(employee_id);
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var supplier_id = response.data.result[i]['supplier_id'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var address = response.data.result[i]['address'];
                    var employee_supplier_id = response.data.result[i]['employee_supplier_id'];

                    data.push({

                        "supplier_id" : supplier_id,
                        "supplier_name" : supplier_name,
                        "address" : address,
                        "delete" : '<button class="btn btn-danger" onclick="disable(' + employee_supplier_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                    });
                }
                //table
                var table = $('#tblSupplier').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }

        }, error: function(data) {
            console.log('Something went wrong!');
            console.log(data);
        }
    })
}


function showModal(event, name) {
    var title = TITLE_MAP[event + name];
    //console.log(title);

    //$('#txtSettingName').attr('name', name);
    $('#settingsAddModalTitle').text(title);
    if (event == SAVE) {
        LoadSupplierData();
    }

    $('#supplierAssignModal').modal('toggle');
}

function disable(id) {
    console.log(id);
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
        type: 'DELETE',
        url: '/fo/EmployeeSupplier/DeleteAssignedSupplier/'+ id,
        success: function(response) {
            console.log(response);
            if (response.data.success) {
                // redrawTable(id);
                GetSuppliersByEmployee(response.data.result.employee_id)
            }


        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}
// function redrawTable(id) {
//     $.ajax({
//         type: 'GET',
//         url: '/fo/EmployeeSupplier/getEmployeeid/' + id,
//         success: function(response) {
//             console.log(response);

//             if (response.data.success) {

//             }

//         }, error: function(data) {
//             console.log('Something went wrong!');
//             console.log(data);
//         }
//     })
// }

// Assign supplier to employee
$('#btnAssignSupplier').on('click', function() {
    var employee_id = $('#hidEmployeeID').val();
    var supplier_id = $('#selectSupplierName').val();
    console.log(employee_id);
    console.log(supplier_id);

    AssignNewSupplier(employee_id, supplier_id);

})

function AssignNewSupplier(employee_id, supplier_id) {
    $.ajax({
        type: 'POST',
        url: '/fo/EmployeeSupplier/AssignNewSupplier',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            },
        data: {
            "employee_id" : employee_id,
            "supplier_id" : supplier_id
        },
        success: function (response) {
            console.log(response);
            if(response.data.success) {
                toastr.success('Supplier Assigned To Employee Successfully!');
                var emp_id = response.data.result;
                GetSuppliersByEmployee(emp_id);
                $('#supplierAssignModal').modal('hide');
            } else{
                toastr.error('Ooops! Try Again Later!');
            }

        }, error: function (data) {
            console.log('Something went wrong');
        }
    })
}



// Load supplier data in to bootstrap modal
function LoadSupplierData() {
    $.ajax({
        type: 'GET',
        url: '/fo/EmployeeSupplier/getAllSuppliers',
        success: function(response) {
            console.log(response);
            var html = '';
            if (response.data.success) {
                $.each(response.data.result, function(index, value) {
                    html += '<option value="' +value.supplier_id+ '">' +value.supplier_name+ '</option>';
                    //console.log(html);
                })
                // $('#selectSupplierName').html(html);

                $('#selectSupplierName').append(html); //modifide by nipuna
            }


        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}


// Get Supplier address
function  SupplierAddressBySupplierID() {
    var supplier_id = $('#selectSupplierName').val();
    console.log(supplier_id);
    $.ajax({
        type: 'GET',
        url: '/fo/EmployeeSupplier/GetSupplierAddressBySupplierID/' + supplier_id,
        success: function(response) {
            console.log(response);

            if (response.data.success) {
                var address = response.data.result[0]['address'];

                $('#txtSupplierAddress').text(address);
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}
