LoadSupplierID();
LoadAllSupplierData();
LoadFieldOfficerName();
//CreateSupplierPlanSchedule();
$(document).ready(function() {

    $('#tblEmployeeSchedule').DataTable({
        scrollX: true,
        "order": [],
        "columns": [
            { "data": "supplier_id"},
            { "data": "supplier_name"},
            { "data": "location"},
            { "data": "material"},
            { "data": "mobile"},
            { "data": "date"},
            { "data": "quantity"},
            { "data": "switch", className: "switch"  },


        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 },
            { width: 50, targets: 6 },
            { width: 50, targets: 7 },
        ],
    });

    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false,
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
        getAllEmployeesBySupervisor(supervisor_id);
    });




    $('.clockpicker-example').clockpicker({
        autoclose: true,
        use24hours: true,
    });
})

// This function is use to load field officer id in to auto complete
function LoadSupplierID () {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetSupplierId',
        success: function(response) {
            console.log(response);
            if (response.data.success) {
                $('#auto-comp1').setData(response.data.result);
            }
        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}

function LoadAllSupplierData() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetAllSupplierData',
        success: function(response) {
            console.log(response);

            var data = [];
            if (response.data.success) {
                for (i = 0; i < response.data.result.length ; i++) {
                    var supplier_id = response.data.result[i]['supplier_id'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var location = response.data.result[i]['town'];
                    var material = response.data.result[i]['product_name'];
                    var telephone_number = response.data.result[i]['mobile'];
                    var date = response.data.result[i]['trans_date'];
                    var quantity = response.data.result[i]['quantity'];

                    data.push({
                        "supplier_id": supplier_id,
                        "supplier_name": supplier_name,
                        "location": location,
                        "material": material,
                        "mobile": telephone_number,
                        "date": date,
                        "quantity": quantity,
                        "switch": '<button class="btn btn-success"><i class="fa fa-exchange" aria-hidden="true"></i></button>',
                    });

                }

                //table
                var table = $('#tblEmployeeSchedule').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        }
    })
}

// This function is use to load field officer name in to auto complete
function LoadFieldOfficerName() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetFieldOfficerName',
        success: function(response) {
            console.log(response);
            if (response.data.success) {
                $('#auto-comp2').setData(response.data.result);
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    });
}

// This function is override from autoCompleteSelectedOption.min.js
function autoCompleteSelectedOption(input, data) {
    //console.log(input);
    console.log(data);
    loadOfficer(data.id);
    clearCalander();
    GetAllSupplierByEmployee(data.id);
}

function loadOfficer(employee_id) {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetOfficerNameById/' + employee_id,
        success: function(response) {
            console.log(response);
            if (response.data.success) {
                var officer = response.data.result[0];
                $('#imgEmployee').attr("src", officer.photo_parth);
                $('#employee_id').val(officer.employee_id);
                $('#auto-comp1').val(officer.employee_id);
                $('#auto-comp2').val(officer.name_withinitial);
            }
        }, error: function(error) {
            console.log(error);
        }
    })
}

// daterangepicker JS

var start = moment().subtract(29, 'days');
var end = moment();

function cb(start, end) {
    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    var start_date = new Date(start);
    var end_date = new Date(end);

    var str_start = start_date.getFullYear() + "-" + (start_date.getMonth() + 1) + "-" + start_date.getDate();
    var str_end = end_date.getFullYear() + "-" + (end_date.getMonth() + 1) + "-" + end_date.getDate();

}

$('#dashboard-daterangepicker').daterangepicker({
    startDate: start,
    endDate: end,
    opens: $('body').hasClass('rtl') ? 'right' : 'left',
    ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
}, cb);

cb(start, end);

// This function is use to get supplier Plans by employee
function GetAllSupplierByEmployee(id) {
    console.log(id);
    CreateSupplierPlanSchedule(id);
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetSupplierPlanByEmployee/' + id,
        success: function(response) {
            console.log(response);

            if (response.data.success) {
                AppendSupplierByEmployee(response.data.result);
                //CreateSupplierPlanSchedule(response.data.result);
            }
        }, error: function(data) {
            console.log('Something went wrong!');
        }
    });
}

// This function is use to append supplier plans by employee
function AppendSupplierByEmployee(result) {
    console.log(result);
    var data = [];
    for (i = 0; i < result.length; i++) {
        var supplier_id = result[i]['supplier_id'];
        var supplier_name = result[i]['supplier_name'];
        var location = result[i]['town'];
        var material = result[i]['product_name'];
        var telephone_number = result[i]['mobile'];
        var date = result[i]['trans_date'];
        var quantity = result[i]['quantity'];

        data.push({
            "supplier_id": supplier_id,
            "supplier_name": supplier_name,
            "location": location,
            "material": material,
            "mobile": telephone_number,
            "date": date,
            "quantity": quantity,
            "switch": '<button class="btn btn-success"><i class="fa fa-exchange" aria-hidden="true"></i></button>',
        });

        // $('#tblEmployeeSchedule').DataTable({
        //     destroy: true,
        //     scrollX: true,
        //     "order": [],
        //     "data": data,
        //     "columns": [
        //         { "data": "supplier_id"},
        //         { "data": "supplier_name"},
        //         { "data": "location"},
        //         { "data": "material"},
        //         { "data": "mobile"},
        //         { "data": "date"},
        //         { "data": "quantity"},
        //         { "data": "switch"},
        //     ],
        //     columnDefs: [
        //         { width: 100, targets: 0 },
        //         { width: 50, targets: 3 },
        //         { width: 50, targets: 4 },
        //         { width: 50, targets: 5 },
        //         { width: 50, targets: 6 },
        //         { width: 50, targets: 7 },
        //     ],
        // });
        var table = $('#tblEmployeeSchedule').DataTable();
        table.clear();
        table.rows.add(data).draw();
    }
    //CreateSupplierPlanSchedule();
}

// Create Calender schedule
function CreateSupplierPlanSchedule(id) {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetSupplierPlanByEmployeeToCalender/'+ id,
        success: function(response) {
            console.log(response);
            if (response.data.success) {
                for (i=0; i < response.data.result.length; i++) {
                    var date = response.data.result[i]['trans_date'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var plan_quantity = response.data.result[i]['quantity'];
                    var supply_plan_id = response.data.result[i]['employee_supply_plan_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var employee_id = response.data.result[i]['employee_id'];
                    addShedule(supply_plan_id, supplier_name, date, date, plan_quantity, product_name, employee_id);
                }
                // addShedule(supply_plan_id, supplier_name, date, date, plan_quantity, product_name, employee_id);
                createCalendar();
            }
        }, error: function(data) {
            console.log('Something went wrong!');
        }
    });

}
