console.log('other_activities.js is loading');

const SAVE = "save";
const UPDATE = "update";
// 20010
var userId = uid; //created by nipuna | equal to session user id variable remove later

var designation_id = 0;
if (userId != null) {
    designation_id = getDesignationId(userId);
    // console.log(designation_id);
}
const TITLE_MAP = {
    'savesupplier': 'Assign A New Supplier',
    'updatesupplier': 'Update Supplier',
    'saveOtherActivity': 'Create A New Other Activity',
    'updateOtherActivity': 'Update Other Activity',
};
var start = moment().subtract(29, 'days');
var end = moment();
var id;
function cb(start, end) {
    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    var start_date = new Date(start);
    var end_date = new Date(end);

    var str_start = start_date.getFullYear() + "-" + (((start_date.getMonth() + 1) > 9 ? '' : '0') + (start_date.getMonth() + 1)) + "-" + ((start_date.getDate() > 9 ? '' : '0') + start_date.getDate());
    var str_end = end_date.getFullYear() + "-" + (((end_date.getMonth() + 1) > 9 ? '' : '0') + (end_date.getMonth() + 1)) + "-" + ((end_date.getDate() > 9 ? '' : '0') + end_date.getDate());


    //  console.log(str_start +' - '+str_end);

    if (userId >= 0 && designation_id == 30) {
        $('#hidEmployeeID').val(userId);
        LoadOtherActivityByOfficer(userId);

        // filterToDateByOfficer(str_start, str_end,userId);
    }
    else {

        // filterToDate(str_start, str_end);

    }


}

$('#dashboard-daterangepicker').daterangepicker({
    startDate: start,
    endDate: end,
    opens: $('body').hasClass('rtl') ? 'right' : 'left',
    ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
}, cb);

cb(start, end);

$(document).ready(function () {
    $('#tblSupplierPlan').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "supplier" },
            { "data": "description" },
            { "data": "date" },
            { "data": "edit", className: "edit" },
        ],
    });

    checkUser();

    function checkUser(data) {
        if (userId > 0 && designation_id == 30) {

            $.ajax({
                type: 'GET',
                url: '/fo/FieldOperation/GetSingleFiledOfficer/' + userId,
                success: function (response) {
                    // console.log(response);
                    if (response.data.success) {
                        $('#FieldOfficer_combo').val(userId);
                        $('#auto-comp2').val(response.data.result.name_withinitial);
                        $('#imgEmployee').attr("src", response.data.result.photo_parth);
                        $('#hidEmployeeID').val(userId);

                        loadOfficer(userId);
                    }

                }, error: function (data) {
                    console.log(data);
                    console.log('Something went wrong!');
                }
            })
        }
        else {
            LoadFieldOfficers();
            LoadOfficerNames();
            // LoadSupplierVist();
        }
    }
    // document.getElementById("btnAssignSupplier").disabled = true;

    allType();

    $('#cmbType').on('change', function () {

        $('#txtdescription').val($('#cmbType option:selected').text());
    });


});

function LoadFieldOfficers() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetSupplierId',
        success: function (response) {

            if (response.data.success) {
                // console.log(response.data.result);
                $('#FieldOfficer_combo').setData(response.data.result);

            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}
function LoadOfficerNames() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetFieldOfficerName',
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                $('#auto-comp2').setData(response.data.result);
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}
function loadOfficer(employee_id) {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetOfficerNameById/' + employee_id,
        success: function (response) {

            if (response.data.success) {
                var officer = response.data.result[0];
                $('#imgEmployee').attr("src", officer.photo_parth);
                $('#hidEmployeeID').val(officer.employee_id);
                $('#FieldOfficer_combo').val(officer.employee_id);
                $('#auto-comp2').val(officer.name_withinitial);

                LoadOtherActivityByOfficer(officer.employee_id);

            }
        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}
function getDesignationId(id) {
    var des_id = 0;
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/getDesignationId/' + id,
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        success: function (response) {

            if (response.data.success) {
                if (response.data.result) {
                    des_id = response.data.result.designation_id;

                }
            }
        }, error: function (data) {
            des_id = 0;
        }
    });
    return des_id;
}
// This function is override from autoCompleteSelectedOption.min.js
function autoCompleteSelectedOption(input, data) {


    loadMatchingIdName(input, data);
}
function loadMatchingIdName(input, data) {


    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/getFieldOfficerNametoId/' + data.id,
        success: function (response) {
            console.log(data);

            $('#FieldOfficer_combo').val(data.id);
            $('#hidEmployeeID').val(data.id);
            $('#auto-comp2').val(response.data.result.name_withinitial);
            $('#imgEmployee').attr("src", response.data.result.photo_parth);

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })

    LoadOtherActivityByOfficer(data.id);

}
function showModal(event, name, id) {
    var title = TITLE_MAP[event + name];
    // console.log(event);
    // console.log(name);

    $('#settingsAddModalTitle').text(title);
    if (event == SAVE) {
        LoadSupplierData();
        $('#btnAssignSupplier').text("Save");
    }


    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();

    var Ontoday = yyyy + '-' + mm + '-' + dd;
    var Ontime = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
    // console.log(Ontoday);
    // console.log(Ontime);
    $('#date').val(Ontoday);


    $('#supplierAssignModal').modal('toggle');
}
function LoadSupplierData() {
    $.ajax({
        type: 'GET',
        url: '/fo/EmployeeSupplier/getAllSuppliers',
        success: function (response) {
            // console.log(response);
            var html = '';
            if (response.data.success) {
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.supplier_id + '">' + value.supplier_name + '</option>';
                    //console.log(html);
                })
                $('#selectSupplierName').html(html);
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}
// Create new supplier visit
$('#btnSaveOtherAtivity').on('click', function () {

    if ($('#btnSaveOtherAtivity').text() == "Save") {
        var date = $('#date').val();
        var supplierId = $('#selectSupplierName').val();
        var employeeId = $('#hidEmployeeID').val();
        var description = $('#txtdescription').val();
        var type_id = $('#cmbType').val();

        // console.log(arrivedOn);
        // console.log(supplierId);
        // console.log(employeeId);
        // console.log(description);


        createOtherActivity(date, supplierId, employeeId, description,type_id);


    } else if ($('#btnSaveOtherAtivity').text() == "Update") {
        var date = $('#date').val();
        var supplierId = $('#selectSupplierName').val();
        var employeeId = $('#hidEmployeeID').val();
        var description = $('#txtdescription').val();
        var Other_Activity_id = $('#hidOtheractivityId').val();
        var type_id = $('#cmbType').val();
        UpdateOtherActivity(date, supplierId, employeeId, description, Other_Activity_id,type_id);
    }
})
function createOtherActivity(date, supplierId, employeeId, description, type_id) {

    $.ajax({

        type: 'POST',
        url: '/fo/OtherActivities/createOtherActivity',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        },
        data: {
            "employee_id": employeeId,
            "Date": date,
            "supplier_id": supplierId,
            "description": description,
            "type_id": type_id

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                toastr.success('Supplier Visit Created Successfully!');
                $('#supplierAssignModal').modal('hide');
                LoadOtherActivityByOfficer(response.data.result);
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}
function LoadOtherActivityByOfficer(id) {
    CreateOtherActivitySchedule(id);
    $.ajax({
        type: 'GET',
        url: '/fo/OtherActivities/LoadOtherActivityByOfficer/' + id,
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var other_Activity_id = response.data.result[i]['id'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var activityDate = response.data.result[i]['Date'];
                    var description = response.data.result[i]['description'];
                    // $('#hidSupVisitId').val(other_Activity_id);

                    data.push({
                        "supplier": supplier_name,
                        "description": description,
                        "date": activityDate,
                        "edit": '<button class="btn btn-primary" onclick="Edit(' + other_Activity_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                    });
                }
                var table = $('#tblSupplierPlan').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }

        }, error: function (data) {
            console.log('Something Went Wrong');
        }
    })
}
function Edit(id) {
    //console.log(id);
    var title = TITLE_MAP['update' + 'OtherActivity'];
    //console.log(title);
    $('#settingsAddModalTitle').text(title);
    $('#btnSaveOtherAtivity').text("Update");
    GetOtherActivityDataToModal(id);

    $('#supplierAssignModal').modal('toggle');

}
// Get data to update modal
function GetOtherActivityDataToModal(id) {
    console.log(id);

    $.ajax({
        type: 'GET',
        url: '/fo/OtherActivities/GetOtherActivityDataToModal/' + id,
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                LoadSupplierData();
                var supplier_id = response.data.result[0]['supplier_id'];
                var supplier_name = response.data.result[0]['supplier_name'];
                var date = response.data.result[0]['Date'];
                var description = response.data.result[0]['description'];
                var Other_Activity_id = response.data.result[0]['id'];
                var type_id = response.data.result[0]['type_id'];

                $('#date').val(date);
                $('#txtdescription').val(description);
                $('#hidSupplierId').val(supplier_id);
                $('#hidOtheractivityId').val(Other_Activity_id);
                $('#selectSupplierName').filter(function (params) {
                    return $(this).text() == supplier_name;
                }).prop('selected', true);
                setSelectedOption('cmbType',type_id);



            }

        }, error: function (data) {
            console.log('Something went wrong');
        }
    })
}
function UpdateOtherActivity(date, supplierId, employeeId, description, Other_Activity_id,type_id) {
    $.ajax({
        type: 'POST',
        url: '/fo/OtherActivities/UpdateOtherActivity/' + Other_Activity_id,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        },
        data: {
            "employee_id": employeeId,
            "Date": date,
            "supplier_id": supplierId,
            "description": description,
            "type_id": type_id,
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                toastr.success('Supplier Visit Updated!');
                $('#supplierAssignModal').modal('hide');
                if (response.data.result == 1) {
                    // LoadSupplierVist();
                }
                LoadOtherActivityByOfficer(response.data.result);
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}
function CreateOtherActivitySchedule(id) {
    // console.log('CreateSupplierVisitSchedule');
    clearCalander();
    $.ajax({
        type: 'GET',
        url: '/fo/OtherActivities/CreateOtherActivitySchedule/' + id,
        success: function (response) {
            // console.log(response);
            if (response.data.success) {


                for (i = 0; i < response.data.result.length; i++) {
                    var date = response.data.result[i]['Date'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var Activity_id = response.data.result[i]['id'];
                    var employee_id = response.data.result[i]['employee_id'];
                    var newDate = date.substring(0, 10);
                    console.log(newDate);
                    // console.log(supplier_name);
                    // console.log(Activity_id);
                    // console.log(employee_id);

                    addShedule(Activity_id, supplier_name, newDate, newDate, employee_id, date);
                }
                createCalendar();
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}



function allType() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/allType',
        success: function (response) {

            if (response.data.success) {
                var types = response.data.result;
                if (types.length > 0) {
                    $('#txtdescription').val(types[0].type);
                }

                $('#cmbType').empty();
                for (var i = 0; i < types.length; i++) {
                    $('#cmbType').append('<option value="' + types[i].id + '">' + types[i].type + '</option>');
                }

            }
        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}
