var CAN_SAVE_FO = false;
$(document).ready(function () {

    var max_year = (parseInt(serverDate().split('/')[0]) + 1);
    var min_year = (max_year - 5);
    for (var i = min_year; i <= max_year; i++) {

        $('#cmbYear').append('<option value="' + i + '">' + i + '</option>');
    }

    setSelectedOption('cmbYear', (max_year - 1));
    setSelectedOption('cmbMonth', parseInt(serverDate().split('/')[1])); 
    sites();
    mainRawMaterials();


    $('#btnSavePlanProduct').on('click', function () {

        savePlanProduct();
    });


    $('#btnSavePlanProductFieldOfficer').on('click', function () {

        saveFieldOfficerQuantity();
    });





    $('#cmbSite').on('change', function () {
        mainRawMaterials();
    });

    $('#cmbYear').on('change', function () {
        mainRawMaterials();
    });

    $('#cmbMonth').on('change', function () {
        mainRawMaterials();
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        var site = param[0].split('=')[2].split('&')[0];
        var year = param[0].split('=')[3].split('&')[0];
        var month = param[0].split('=')[4].split('&')[0];
        var action = param[0].split('=')[5].split('&')[0];

        setSelectedOption('cmbSite', site);
        setSelectedOption('cmbYear', year);
        setSelectedOption('cmbMonth', month);
        mainRawMaterials();
        if (action == 'edit') {

        } else if (action == 'view') {
            $('#btnSavePlanProduct').hide();
            $('#btnSavePlanProductFieldOfficer').hide();
        }



    }

});



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



function sites() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductController/sites',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.site_id + '">' + value.site + '</option>';
                })
                $('#cmbSite').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}



function mainRawMaterials() {

    $('#table_main_plan_body').empty();
    if ($('#cmbSite option:selected').text() == 'Unspecified') {
        return;
    }
    CAN_SAVE_FO = false;
    $('#btnSavePlanProduct').show();
    $('#btnSavePlanProductFieldOfficer').show();
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductController/mainRawMaterials/' + $('#cmbYear').val() + "/" + $('#cmbMonth').val() + "/" + $('#cmbSite').val(),
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                var result = response.data.result;
                $('#table_main_plan_body').empty();
                $('#table_plan_product_employee_body').empty();
                for (var i = 0; i < result.length; i++) {

                    var str_txt_quantity_id = "txt_quantity" + i;
                    var str_txt_stock_in_h_id = "txt_stock_in_h" + i;
                    var str_txt_production_requirmrnt_id = "txt_production_requirmrnt" + i;
                    var str_txt_re_order_level_id = "txt_re_order_level" + i;
                    var str_txt_broaght_forward_id = "txt_broaght_forward" + i;
                    var str_txt_requirment_id = "txt_requirment" + i;


                    var plan_product_id = result[i]['plan_product_id'];
                    var quantity = result[i]['quantity'];
                    var stock_inh = result[i]['stock_inh'];
                    var production_requirment = result[i]['production_requirment'];
                    var reorder_level = result[i]['re_order_level'];
                    var broaght_forward = result[i]['broaght_forward'];
                    var requirment = result[i]['requirment'];

                    var row = '<tr id="' + plan_product_id + '" data-id="' + result[i]['product_primary_id'] + '"><td id="' + result[i]['product_primary_id'] + '" style="width: 100%;" >' + result[i]['product_name'] + '</td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + str_txt_quantity_id + '" value="' + parseFloat(quantity).toFixed(2) + '" oninput="computerRequirment(' + i + ')"></td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + str_txt_stock_in_h_id + '" value="' + parseFloat(stock_inh).toFixed(2) + '" oninput="computerRequirment(' + i + ')" disabled></td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + str_txt_production_requirmrnt_id + '" value="' + parseFloat(production_requirment).toFixed(2) + '" oninput="computerRequirment(' + i + ')" disabled></td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + str_txt_re_order_level_id + '" value="' + parseFloat(reorder_level).toFixed(2) + '" oninput="computerRequirment(' + i + ')" disabled></td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + str_txt_broaght_forward_id + '" value="' + parseFloat(broaght_forward).toFixed(2) + '" oninput="computerRequirment(' + i + ')" disabled></td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + str_txt_requirment_id + '" value="' + parseFloat(requirment).toFixed(2) + '" disabled></td>';
                    if (plan_product_id == 'undefined' || parseFloat(quantity) == 0) {
                        row += '<td id="action' + i + '" style="min-width: 100px;"><button class="btn btn-primary" data-toggle="modal" data-target="#planModal">Allotment</button></td></tr>';
                    } else {
                        row += '<td id="action' + plan_product_id + '" style="min-width: 100px;"><button class="btn btn-primary" data-toggle="modal" data-target="#planModal">Allotment</button></td></tr>';

                    }
                    $('#table_main_plan_body').append(row);
                    if (plan_product_id == 'undefined' || parseFloat(quantity) == 0) {
                        $('#action' + i).hide();
                    }
                }

            }




        },
        error: function (data) {

        },
        complete: function () {

        }
    });

    $('#table_main_plan tbody tr').click(function () {


        $(this).addClass('bg-primary').siblings().removeClass('bg-primary');
        if ($(this).attr('id') != 'undefined') {
            CAN_SAVE_FO = true;
        }
        fieldOfficers($(this).attr('data-id'), $(this).attr('id'));
        //alert($(this).attr('id'));
    });
}


function computerRequirment(id) {
    var quantity = parseFloat($('#txt_quantity' + id).val());
    var stock_in_h = parseFloat($('#txt_stock_in_h' + id).val());
    var production_requirmrnt = parseFloat($('#txt_production_requirmrnt' + id).val());
    var re_order_level = parseFloat($('#txt_re_order_level' + id).val());
    var broaght_forward = parseFloat($('#txt_broaght_forward' + id).val());
    var requirment = (stock_in_h + production_requirmrnt + re_order_level + broaght_forward) - quantity;
    if (isNaN(requirment)) {
        requirment = (stock_in_h + production_requirmrnt + re_order_level + broaght_forward);
    }
    $('#txt_requirment' + id).val(requirment.toFixed(2));
}




function savePlanProduct() {

    if ($('#table_main_plan_body tr').length == 0) {
        showWarningMessage("Invalied Main plan");
        return;
    }
    $.ajax({
        type: "POST",
        url: '/fo/PlanProductController/savePlanProduct',
        data: { 'data': dataSource() },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Saved data.');
                mainRawMaterials();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}




function dataSource() {

    var collection = {};
    var table = document.getElementById('table_main_plan_body'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;



    for (i = 0, j = rows.length; i < j; ++i) {
        var plan_product_id = rows[i].id;
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }

        var data = {
            "plan_product_id": plan_product_id,
            "site_id": $('#cmbSite').val(),
            "year": $('#cmbYear').val(),
            "month": $('#cmbMonth').val(),
            "product_id": cells[0].id,
            "quantity": cells[1].childNodes[0].value,
            "stock_in_h": cells[2].childNodes[0].value,
            "production_requirment": cells[3].childNodes[0].value,
            "re_order_level": cells[4].childNodes[0].value,
            "broaght_forward": cells[5].childNodes[0].value,
            "requirment": cells[6].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);



    }

    return collection;

};





function dataSourceFieldOfficer() {

    var collection = {};
    var table = document.getElementById('table_plan_product_employee_body'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;



    for (i = 0, j = rows.length; i < j; ++i) {
        var plan_product__employee_id = rows[i].id;
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }

        var data = {
            "plan_product__employee_id": plan_product__employee_id,
            "field_officer_id": cells[0].id,
            "product_primary_id": cells[0].childNodes[0].value,
            "plan_product_id": cells[0].childNodes[1].value,
            "quantity": cells[1].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);



    }

    return collection;

};




function fieldOfficers(product_primary_id, plan_product_id) {

    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductController/fieldOfficers/' + plan_product_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {
                var result = response.data.result;
                $('#table_plan_product_employee_body').empty();
                for (var i = 0; i < result.length; i++) {

                    var txt_quantity_id = "txt_fo_quantity" + i;
                    var plan_product_employee_id = result[i]['plan_product_employee_id'];
                    var quantity = result[i]['quantity'];

                    var row = '<tr id="' + plan_product_employee_id + '"><td id="' + result[i]['employee_id'] + '" style="width: 100%;" ><input type="hidden" value="' + product_primary_id + '"><input type="hidden" value="' + plan_product_id + '">' + result[i]['name_withinitial'] + '</td>';
                    row += '<td style="min-width: 100px;"><input type="text" class="form-control" style="text-align:right;" id="' + txt_quantity_id + '" value="' + parseFloat(quantity).toFixed(2) + '"></td></tr>';
                    $('#table_plan_product_employee_body').append(row);
                }

            }

        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}



function saveFieldOfficerQuantity() {


    if (!CAN_SAVE_FO) {
        showWarningMessage('Save Main Plan.');
        return;
    }

    $.ajax({
        type: "POST",
        url: '/fo/PlanProductController/saveFieldOfficerQuantity',
        data: {
            'data': dataSourceFieldOfficer(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var product_primary_id = response.data.result['product_primary_id'];
                var plan_product_id = response.data.result['plan_product_id'];
                showSuccessMessage('Saved data.');
                fieldOfficers(product_primary_id, plan_product_id);
                $('#planModal').modal('hide');
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });

}

function show_hide_column(col_no, do_show) {
    var tbl = document.getElementById('table_main_plan');
    var col = tbl.getElementsByTagName('col')[col_no];
    if (col) {
        col.style.visibility = do_show ? "" : "collapse";
    }
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}




