



$(document).ready(function () {

    $('#tableMainPlanList').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "site" },
            { "data": "year" },
            { "data": "month" },
            { "data": "edit" },
            { "data": "view" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 150, targets: 1 },
            { width: 150, targets: 2 },
            { width: 30, targets: 3 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 }
        ],
    });

    getMainPlanList();

});



function getMainPlanList() {


    var MONTH_NAME_EN = {
        1: 'january',
        2: 'February',
        3: 'March',
        4: 'April',
        5: 'May',
        6: 'June',
        7: 'July',
        8: 'August',
        9: 'September',
        10: 'October',
        11: 'November',
        12: 'December',
    }


    $.ajax({
        type: "GET",
        url: "/fo/PlanProductListController/getMainPlanList",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(response);
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {

                    var plan_product_id = response.data.result[i]['plan_product_id'];
                    var site_id = response.data.result[i]['site_id'];
                    var site = response.data.result[i]['site'];
                    var year = response.data.result[i]['year'];
                    var month = response.data.result[i]['month'];
                    var str_plan_product_id = "'" + plan_product_id + "'";
                    var str_site = "'" + site_id + "'";
                    var str_year = "'" + year + "'";
                    var str_month = "'" + month + "'";
                    var edit_button = '<button type="button" class="btn btn-primary" onclick="edit(' + str_plan_product_id + ',' + str_site + ',' + str_year + ',' + str_month + ')" ><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>';
                    var view_button = '<button type="button" class="btn btn-success" onclick="view(' + str_plan_product_id + ',' + str_site + ',' + str_year + ',' + str_month + ')" ><i class="fa fa-eye" aria-hidden="true"></i></button>';
                    var delete_button = '<button type="button" class="btn btn-danger" onclick="_delete(' + str_plan_product_id + ',' + str_site + ',' + str_year + ',' + str_month + ')" ><i class="fa fa-trash" aria-hidden="true"></i></button>';

                    data.push({
                        "site": site,
                        "year": year,
                        "month": MONTH_NAME_EN[month],
                        "edit": edit_button,
                        "view": view_button,
                        "delete": delete_button,
                    });
                }

                var table = $('#tableMainPlanList').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function edit(id, site, year, month) {
    location.href = "/fo/plan_product?id=" + id + "&site=" + site + "&year=" + year + "&month=" + month + "&action=edit";
}


function view(id, site, year, month) {
    location.href = "/fo/plan_product?id=" + id + "&site=" + site + "&year=" + year + "&month=" + month + "&action=view";
}

function _delete(id, site, year, month) {

    $.ajax({
        type: 'DELETE',
        url: '/fo/PlanProductListController/delete/' + site + "/" + year + "/" + month,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Main Plan has been deleted successfully...")
                getMainPlanList();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}