var start = moment().startOf('month');
var end = moment().endOf('month');

$(document).ready(function () {

    $('#tblEmployeeSchedule').DataTable({
        scrollX: true,
        "order": [],
        "columns": [
            { "data": "supplier_id" },
            { "data": "supplier_name" },
            { "data": "mobile" },
            { "data": "date" },
            { "data": "detail" },
            //{ "data": "action" },


        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 100, targets: 2 },
            { width: 100, targets: 3 },
            //{ width: 50, targets: 7 },
        ],
    });



    $('#dashboard-daterangepicker').daterangepicker({
        startDate: start,
        endDate: end,
        opens: 'right',
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    });

    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));



    $('#dashboard-daterangepicker').on('apply.daterangepicker', function (ev, picker) {
        $('#dashboard-daterangepicker span').html(picker.startDate.format('MMMM D, YYYY') + ' - ' + picker.endDate.format('MMMM D, YYYY'));
        loadPlan();
        loadVisitCalanderPlan();
    });


    allFieldOfficerID();
    allFieldOfficerName();


});




function allFieldOfficerID() {
    $.ajax({
        type: 'GET',
        url: '/fo/VisitPlanController/allFieldOfficerID',
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                $('#auto-comp1').setData(response.data.result);
            }
        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}



function allFieldOfficerName() {
    $.ajax({
        type: 'GET',
        url: '/fo/VisitPlanController/allFieldOfficerName',
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                $('#auto-comp2').setData(response.data.result);
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    });
}


function autoCompleteSelectedOption(input, data) {
 

    if (input.id == 'auto-comp1') {
        $('#auto-comp2').attr('data-id', data.id);
        $('#auto-comp2').val(getSelectedFieldOfficerName(data.id));
    } else if (input.id == 'auto-comp2') {
        $('#auto-comp1').attr('data-id', data.id);
        $('#auto-comp1').val(data.id);
    }
    $('#imgEmployee').attr("src", data.img);
    loadPlan();
    loadVisitCalanderPlan();
}



function getSelectedFieldOfficerName(id) {
    var name = "";
    $.ajax({
        type: 'GET',
        url: '/fo/VisitPlanController/getSelectedFieldOfficerName/' + id,
        async: false,
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                name = response.data.result;
            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    });

    return name;
}



function loadPlan() {

    var officer_id = $('#auto-comp1').optionID();
    var startDate = $('#dashboard-daterangepicker').data('daterangepicker').startDate.format('YYYY-MM-DD');
    var endDate = $('#dashboard-daterangepicker').data('daterangepicker').endDate.format('YYYY-MM-DD');

    $.ajax({
        type: "GET",
        url: "/fo/VisitPlanController/loadPlan/" + officer_id + "/" + startDate + "/" + endDate,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data);
            var result = response.data.result;

            var data = [];
            for (var i = 0; i < result.length; i++) {
                var supplier_id = result[i]['supplier_id'];
                var supplier_name = result[i]['supplier_name'];
                var mobile = result[i]['mobile'];
                var date = result[i]['visit_date'];
                var detail = result[i]['visit_detail'];
                //var button = '<button class="btn btn-success"><i class="fa fa-exchange" aria-hidden="true"></i></button>';

                data.push({
                    "supplier_id": supplier_id,
                    "supplier_name": supplier_name,
                    "mobile": mobile,
                    "date": date,
                    "detail": detail,
                    //"action": button,
                });
            }

            var table = $('#tblEmployeeSchedule').DataTable();
            table.clear();
            table.rows.add(data).draw();


        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}