@extends('fo::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('assets/js/autocomplete/css/autocomplete.min.css') }}">

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link href="{{ asset('assets/css/hr/settings.css') }}" media="all" rel="stylesheet" type="text/css" />

<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<!-- <div class="page-header">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-cur2wrent="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div> -->

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Employee Supplier</h6>
                <div class="row">
                    <!--Left side -->
                    <div class="col-md-12">
                        <div class="row">
                            <!-- <div class="col-md-12 mb-3">
                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                            <label for="txtSupplyDate">Date</label>
                            <input type="text" class="form-control" id="txtSupplyDate" name="txtSupplyDate">
                            <div class="valid-feedback">
                                Looks good!
                            </div>

                        </div> -->
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                <label>Employee</label>
                                <input type="hidden" id="hidEmployeeID" name="hidEmployeeID" value="">
                                <input type="text" class="form-control auto-complete" id="txtSupplier" name="txtSupplier" placeholder="Employee" required="" autocomplete="off">
                            </div>
                        </div>
                        <!-- <div class="row">
                            <div class="col-md-12">
                                <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                                <label>Address</label>
                                <textarea class="form-control" id="txtEmployeeAddress" name="txtEmployeeAddress" placeholder="Address"></textarea>
                            </div>
                        </div> -->

                        <br>
                        <div class="row">
                            <div class="col-md-5">
                                <div>
                                    <button type="button" id="btnGrp1modal" class="btn btn-primary" data-target="#supplierAssignModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save', 'supplier')">
                                        <i class="fa fa-plus" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-12">
                                <table id="tblSupplier" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                    <thead>
                                        <tr>
                                            <th>Supplier ID</th>
                                            <th>Supplier Name</th>
                                            <th>Address</th>
                                            <th class="delete">Delete</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tPlanListBody"></tbody>
                                </table>
                            </div>


                        </div>



                        <hr>

                        <div class="row">
                            <div class="col-md-12">
                                <br>
                                <button type="button" class="btn btn-primary" id="btnAddToList" onclick="GetSelected()">Add To List</button>
                            </div>
                        </div>

                    </div>



                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal  -->
<div class="modal fade" id="supplierAssignModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="settingsAddModalTitle">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <form method="POST" id="myForm">
                {{csrf_field()}}
                <input type="hidden" id="supplierID" name="supplierID" value>
                <div class="modal-body" id="settingsAddModalBody">
                    <div class="form-row">
                        <div class="col-md-12 mb-3" id="divSection">
                            <input type="hidden" id="hidSupplierId" name="hidSupplierId">
                            <label for="txtName" id="lblSupplierName">Supplier Name</label>
                            <select class="form-control" id="selectSupplierName" name="selectSupplierName" onchange="SupplierAddressBySupplierID()">
                                <option value="">Select Supplier</option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label>Address</label>
                            <textarea class="form-control" id="txtSupplierAddress" name="txtSupplierAddress" placeholder="Address"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnAssignSupplier">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- <div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body" id="attachmentAddModalBody">
                <div class="row">
                    <div class="col-md-12">
                        <form action="{{route('upload')}}" class="dropzone" method="POST" id="myAwesomeDropzone" name="myAwesomeDropzone">
                            @csrf
                            <input type="hidden" id="employee_id" name="employee_id" value="">
                            <div class="fallback">
                                <input name="file" type="file" multiple/>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSetting" onclick="save()">Save</button>
                </div>
            </div>
        </div>
    </div> -->
<!-- autocomplete  -->
<script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<!-- jquery ui library  -->
<script src="{{ url('assets/js/ui/jquery-ui.min.js') }}"></script>

<script>
    var supplier_datas = LoadSuppliers();

    console.log(supplier_datas);


    $('#txtSupplier').setData(supplier_datas);


    function autoCompleteSelectedOption(input, data) {

        if (input.id == "txtSupplier") {
            var id = data.id;
            console.log(id);
            $('#hidEmployeeID').val(id);
            GetSuppliersByEmployee(id);
        }
    }

    function LoadSuppliers() {
        var supplier_data = [];
        $.ajax({
            type: 'GET',
            url: '/fo/EmployeeSupplier/getEmployee',
            success: function(response) {
                console.log(response);
                response.data.result.forEach(function(element) {
                    supplier_data.push({
                        "img": "",
                        "id": element['employee_id'],
                        "value": element['name_withinitial']
                    });
                });

                // var supplier_data = response.data.result.map((array) => ({ img: array.address, id: array.supplier_id, value: array.supplier_name }));
                // var supplier_data = response.data.result.map(function (array) { return {img: array.address, id: array.supplier_id, value: array.supplier_name}; });

            },
            error: function(data) {
                console.log('something went wrong!');
            }
        });
        return supplier_data;
    }
</script>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>

<!-- Javascript -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<!-- <script src="{{ url('assets/js/hr/supplier_material.js') }}"></script> -->

<!-- Module JS -->
<script src="{{ Module::asset('fo:js/fo/employee_supplier.js') }}"></script>


@endsection