@extends('fo::layouts.app')

@section('head')

<meta charset="ISO-8859-1">

<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.css') }}" type="text/css">

<!-- Fullcalendar -->
<link rel="stylesheet" href="{{ url('vendors/fullcalendar/fullcalendar.min.css') }}" type="text/css">

<!-- Map JS  -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-map/3.0-rc1/jquery.ui.map.js"></script>
<!-- <script src="https://maps.googleapis.com/maps/api/js"></script> -->

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<link href="{{ asset('assets/css/hr/settings.css') }}" media="all" rel="stylesheet" type="text/css" />

<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">
<script>
    var uid = "{{Auth::user()->user_id}}";
</script>
@endsection

@section('content')



<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Other Activities</h6>
                <div class="row">
                    <div class="col-md-7">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer ID</label>
                                <input type="hidden" value="1" id="hidEmployeeID" name="hidEmployeeID">
                                <input type="text" class="form-control auto-complete" id="FieldOfficer_combo" autocomplete="off">
                            </div>
                            <div class="col-md-8 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp2" autocomplete="off">
                            </div>
                        </div>

                        <div class="row">

                            <div class="col-md-8 mb-3">
                                <div id="dashboard-daterangepicker" class="btn btn-outline-light">
                                    <span>Jan, 05, 2021</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="imgContainer">
                                    <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">

                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <ul class="nav nav-pills mb-3" role="tablist" id="navMenuItem">
                            <li class="nav-item">
                                <a class="nav-link active" id="pills-general-tab" data-toggle="pill" href="#tbGeneral" role="tab" aria-controls="pills-general" aria-selected="true">Activities List</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#tbContactInfo" role="tab" aria-controls="pills-contact" aria-selected="false">Calander</a>
                            </li>

                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="tbGeneral" role="tabpanel" aria-labelledby="pills-general-tab">
                                <div class="row">
                                    <div class="col-md-12 seperator">
                                        <div class="card bg-primary">
                                            <div class="card-header">Activities List</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-5">
                                        <div>
                                            <button type="button" id="btnGrp1modal" class="btn btn-primary" data-target="#supplierAssignModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save', 'OtherActivity', null)">
                                                <i class="fa fa-plus" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <table id="tblSupplierPlan" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th class="supplier">Supplier Name</th>
                                                    <th class="description">Description</th>
                                                    <th class="date">Date</th>
                                                    <th class="edit">Edit</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody"></tbody>
                                        </table>
                                    </div>
                                </div>



                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <hr>
                                    </div>
                                </div>

                            </div>
                            <div class="tab-pane fade" id="tbContactInfo" role="tabpanel" aria-labelledby="pills-contact-tab">
                                <div class="card ">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-12 app-content">
                                                <div class="row">
                                                    <div class="col-md-12 seperator">
                                                        <div class="card bg-primary">
                                                            <div class="card-header">Calander</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="app-content-overlay"></div>
                                                <div class="card app-content-body">
                                                    <div class="card-body">

                                                        <br>
                                                        <div id="calendar-demo"></div>
                                                    </div>
                                                </div>
                                            </div>



                                            <!-- begin::Event Info Modal -->
                                            <div class="modal fade" id="viewEventModal" tabindex="-1" role="dialog" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">
                                                                <span class="event-icon mr-2"></span>
                                                                <span class="event-title">Modal Title</span>
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <i class="ti-close"></i>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="event-body"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end::Event Info Modal -->
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Supplier visit Modal  -->
    <div class="modal fade" id="supplierAssignModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsAddModalTitle">Add supplier Visit</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form method="POST" id="myForm">
                    {{csrf_field()}}
                    <input type="hidden" id="supplierID" name="supplierID" value>
                    <div class="modal-body" id="settingsAddModalBody">
                        <div class="form-row">
                            <div class="col-md-12 mb-3" id="divSection">
                                <input type="hidden" id="hidSupplierId" name="hidSupplierId">
                                <input type="hidden" id="hidOtheractivityId" name="hidOtheractivityId">
                                <label for="txtName" id="lblSupplierName">Supplier Name</label>
                                <!-- onchange="SupplierAddressBySupplierID()" -->
                                <select class="form-control" id="selectSupplierName" name="selectSupplierName"></select>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="lblType" id="lblType">Type</label>
                                <select class="form-control" id="cmbType" name="type"></select>
                            </div>
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="supplier">Date</label>
                                    </div>
                                    <div class="col-md-9 mb-2">
                                        <input type="text" id="date" name="date" disabled>
                                    </div>
                                    <div class="col-md-1"></div>

                                </div>

                                <div class="row" id="divObservation">
                                    <div class="col-md-3">
                                        <label for="observation">Description</label>
                                    </div>
                                    <br>
                                    <div class="col-md-9">
                                        <textarea class="form-control" id="txtdescription" name="txtdescription" placeholder="Description"></textarea>
                                    </div>
                                </div>
                                <div class="row" id="divLocation">
                                    <div class="col-md-4">

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnSaveOtherAtivity">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<!-- jquery ui library  -->
<!--<script src="{{ url('assets/js/ui/jquery-ui.min.js') }}"></script>!-->



@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')


<!-- AutoComplete -->
<script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>

<!-- Fullcalendar -->
<script src="{{ url('vendors/fullcalendar/moment.min.js') }}"></script>
<script src="{{ url('vendors/fullcalendar/fullcalendar.min.js') }}"></script>

<!-- Javascript -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<!-- <script src="{{ url('assets/js/hr/supplier_material.js') }}"></script> -->

<!-- calender lib  -->
<script src="{{ Module::asset('fo:js/fo/calanderActivity.js') }}"></script>

<!-- Module JS -->
<script src="{{ Module::asset('fo:js/fo/other_activities.js') }}"></script>




<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>


@endsection