<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\Fo\Http\Controllers\SupplierMaterialController;
use Modules\Fo\Http\Controllers\FoController;
use Modules\Fo\Http\Controllers\SupplierVisitController;
use Modules\Fo\Http\Controllers\Supply_planController;
use Modules\Fo\Http\Controllers\SupplyCollectionController;
use Modules\Fo\Http\Controllers\EmlpoyeeSupplierController;

Route::prefix('fo')->group(function () {
    //Route::get('/', 'FoController@index');


    Route::get('/dashboard', function () {
        return view('fo::dashboard');
    })->middleware('is.logged');

    Route::get('/supplier_material', function() {
        return view('fo::supplier_material');
    })->middleware(['is.logged', 'can:fo_setting_material_assign_supplier']);

    Route::get('/planned_materials', function() {
        return view('fo::supply_plan');
    })->middleware(['is.logged', 'can:fo_collection_forcast_create']);

    Route::get('/planned_materials_list', function() {
        return view('fo::supply_plan_list');
    })->middleware(['is.logged', 'can:fo_collection_forcast_list']);

    Route::get('/employee_supply_collection', function() {
        return view('fo::supply_collection');
    })->middleware(['is.logged', 'can:fo_collection_create']);

    Route::get('/employee_supply_collection_list', function() {
        return view('fo::supply_collection_list');
    })->middleware(['is.logged', 'can:fo_collection_list']);

    Route::get('/visit_plan', function() {
        return view('fo::fo_visit_plan');
    })->middleware(['is.logged', 'can:fo_visit_plan']);

    Route::get('/employee_supplier', function() {
        return view('fo::employee_supplier');
    })->middleware(['is.logged', 'can:fo_setting_supplier_assign_field_officer']);

    Route::get('/supplier_visit', function() {
        return view('fo::supplier_visit');
    })->middleware(['is.logged', 'can:fo_visit']);

    //*  Supplier Materials  */
    Route::get('/supplierMaterials/getSupplier', [SupplierMaterialController::class, 'GetSuppliers']);
    Route::get('/supplierMaterials/products', [SupplierMaterialController::class, 'GetProducts']);
    Route::get('/supplierMaterials/GetSupplierAddress/{id}', [SupplierMaterialController::class, 'GetSupplierAddress']);
    Route::get('/supplierMaterials/GetAssignProducts/{id}', [SupplierMaterialController::class, 'GetNewlyAssignedProducts']);
    Route::get('/supplierMaterials/GetSupplierAssignedProducts/{id}', [SupplierMaterialController::class, 'GetSupplierAssignedProducts']);
    Route::post('/supplierMaterials/InsertCheckedProducts', [SupplierMaterialController::class, 'InsertCheckedData']);
    route::post('/supplierMaterials/assignProducts', [SupplierMaterialController::class, 'AssignProduct']);
    // Route::get('/supplierMaterials/GetAssignProducts/{id}', [EmployeeSupplyPlanController::class, 'GetNewlyAssignedProducts']);
    Route::delete('/supplierMaterials/DeleteAssignProducts/{id}', [SupplierMaterialController::class, 'DeleteAssignProducts']);
    //* End of Supplier Materials */


    //* Employee Supplier Collection */
    Route::get('/EmployeeSupplyCollection/getSupplier', [SupplyCollectionController::class, 'GetSuppliers']);
    Route::post('/SupplyCollection/SaveSupplyCollection', [SupplyCollectionController::class, 'InsertSupplyCollection'])->middleware(['is.logged', 'can:fo_collection_create_submit']);
    Route::get('/SupplyCollectionController/GetSupplyCollectionData/{id}', [SupplyCollectionController::class, 'GetSupplyCollectionData']);
    Route::post('/SupplyCollection/GetProductsOnDateToSupplyCollection', [SupplyCollectionController::class, 'GetProductsOnDateToSupplyCollection']);
    Route::post('/SupplyCollection/UpdateSupplyCollection', [SupplyCollectionController::class, 'UpdateSupplyCollection']);
    Route::get('/SupplyCollection/GetSupplyCollectionList', [SupplyCollectionController::class, 'GetSupplierCollectionList']);
    Route::get('/SupplyCollection/GetSupplierAddressToCollection/{id}', [SupplyCollectionController::class, 'LoadPlanToCollection']);
    //* End of Employee Supplier Collection */

    //* Employee Supplier Plan */
    Route::get('/SupplyPlan/getSupplier', [Supply_planController::class, 'GetSuppliers']);
    Route::get('/SupplyPlan/GetSupplyPlan', [Supply_planController::class, 'GetSupplyPlan']);
    Route::get('/SupplyPlan/GetSupplierAddress/{id}', [Supply_planController::class, 'GetSupplierAddress']);
    Route::post('/SupplyPlan/SaveSupplyPlan', [Supply_planController::class, 'InsertSupplyPlan'])->middleware(['is.logged', 'can:fo_collection_forcast_create_submit']);
    Route::get('/SupplyPlan/GetSupplyPlanData/{id}', [Supply_planController::class, 'GetSupplyPlanData']);
    Route::post('/SupplyPlan/GetProductsOnDate', [Supply_planController::class, 'GetProductsOnDate']);
    Route::post('/SupplyPlan/UpdateSupplyPlan', [Supply_planController::class, 'UpdateSupplyPlan']);
    //* End of Employee Supplier Collection */
    //routes by nipuna
    // Route::get('/EmployeeSupplyPlan/Getpreviousdata/{date}', [EmployeeSupplyPlanController::class, 'Getpreviousdata']);

    //* Employee Supplier Plan */
    Route::get('/FieldOperation/GetSupplierId', [EmlpoyeeSupplierController::class, 'GetSupplierId']);
    Route::get('/FieldOperation/GetAllSupplierData', [EmlpoyeeSupplierController::class, 'GetAllSupplierData']);
    Route::get('/FieldOperation/GetFieldOfficerName', [EmlpoyeeSupplierController::class, 'GetFieldOfficerName']);
    Route::get('/FieldOperation/GetOfficerNameById/{id}', [EmlpoyeeSupplierController::class, 'GetOfficerNameById']);
    Route::get('/FieldOperation/GetSupplierPlanByEmployee/{id}', [EmlpoyeeSupplierController::class, 'GetSupplierPlanByEmployee']);

    //routes by nipuna
    Route::get('/FieldOperation/getFieldOfficerNametoId/{id}', [FoController::class, 'getFieldOfficerNametoId']);
    Route::get('/FieldOperation/GetSingleFiledOfficer/{id}', [FoController::class, 'GetSingleFiledOfficer']);
    Route::get('/FieldOperation/getDesignationId/{id}', [FoController::class, 'getDesignationId']);

    Route::get('/FieldOperation/GetSupplierPlanByEmployeeToCalender/{id}', [FoController::class, 'GetSupplierPlanByEmployeeToCalendar']);
    Route::post('/FieldOperation/GetSuppplyPlanDataToModal', [FoController::class, 'GetSupplyPlanDataToModal']);
    //* End of Employee Supplier Collection */

    //** Employee Supplier Asssign */
    Route::get('/EmployeeSupplier/getEmployee', [FoController::class, 'GetEmployees']);
    Route::get('/EmployeeSupplier/getSuppliersByEmployee/{id}', [EmlpoyeeSupplierController::class, 'GetSuppliersByEmployee']);
    Route::get('/EmployeeSupplier/getAllSuppliers', [FoController::class, 'GetSuppliers']);
    Route::get('/EmployeeSupplier/GetSupplierAddressBySupplierID/{id}', [FoController::class, 'GetSupplierAddressBySupplierID']);

    Route::post('/EmployeeSupplier/AssignNewSupplier', [FoController::class, 'AssignNewSuppliers']);

    Route::delete('/EmployeeSupplier/DeleteAssignedSupplier/{id}', [FoController::class, 'DeleteAssignedSuppliers']);
    //** End of employee supplier Assign */

    //** Supplier Visit */
    Route::post('/SupplierVisit/createSupplierVisit', [SupplierVisitController::class, 'CreateSupplierVisit']);
    Route::get('/SupplierVisit/LoadSupplierVisit', [SupplierVisitController::class, 'GetSupplierVist']);
    Route::get('/SupplierVisit/GetsupplierVisitDataToModal/{id}', [SupplierVisitController::class, 'GetSupplierVisitDataToModal']);
    Route::post('/SupplierVisit/UpdateSupplierVisit/{id}', [SupplierVisitController::class, 'UpdateSupplierVisit']);
    Route::get('/SupplierVisit/GetSupplierByOfficer/{id}', [SupplierVisitController::class, 'GetSupplierByOfficer']);
    Route::get('/SupplierVisit/GetSupplierVisitByEmployee/{id}', [SupplierVisitController::class, 'GetSupplierVisitByEmployee']);
    Route::get('/SupplierVisit/GetSupplierVisitByEmployeeToCalander/{id}', [SupplierVisitController::class, 'GetSupplierVisitByEmployeeToCalander']);
    Route::post('/SupplierVist/GetSupplierVisitToModal', [SupplierVisitController::class, 'GetSupplierVisitToModal']);
    Route::get('/SupplierVisit/GetSupplierVisitByDate', [SupplierVisitController::class, 'GetSupplierVisitByDate']);

    //** End of supplier visit */
});
