<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeSupplyPlan extends Model
{
    protected $table = 'fo_employee_supply_plans';
    protected $primaryKey = 'employee_supply_plan_id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'employee_supply_plan_id',
        'employee_id',
        'supplier_id',
        'trans_date',
        'product_id',
        'quantity',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_employee_supply_plans";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

    // protected $fillable = [];
    
    // protected static function newFactory()
    // {
    //     return \Modules\Fo\Database\factories\EmployeeSupplyPlanFactory::new();
    // }
}
