<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class OtherActivityType extends Model
{
    protected $table = 'fo_other_activity_types';
    use HasFactory, LogsActivity;
    protected static $logAttributes = [
        'id',
        'type',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_other_activity_types";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

    /*protected static function newFactory()
    {
        return \Modules\Fo\Database\factories\OtherActivityTypeFactory::new();
    }*/
}
