<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class PlanProduct extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'fo_plan_products';
    protected $primaryKey = 'plan_product_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'plan_product_id',
        'site_id',
        'product_primary_id',
        'quantity',
        'stock_in_h',
        'production_requirment',
        're_order_level',
        'broaght_forward',
        'requirment',
        'year',
        'month',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_plan_products";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
