<?php

namespace Modules\Fo\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class SupplierVisitPlan extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    
    protected $table = 'fo_supplier_visit_plans';
    protected $primaryKey = 'supplier_visit_plan_id';
    protected static $logAttributes = [
        'supplier_visit_plan_id',
        'employee_id',
        'supplier_id',
        'supplier_name',
        'visit_area',
        'remarks',
        'visit_date',
        'visit_detail',
        'year',
        'month',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "fo_supplier_visit_plans";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
