<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Fo\Entities\PlanProduct;
use Modules\Fo\Entities\PlanProductEmployee;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Pp\Entities\MachineryPlan;
use Modules\St\Entities\Product;

class PlanProductController extends Controller
{
    function sites()
    {
        try {
            $Site = EmployeeSite::all();

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "sites", $Site);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "sites", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    function mainRawMaterials($year, $month, $site)
    {
        try {
            $materials = Product::where('product_type_id', '=', '1')->get();
            foreach ($materials as $material) {
                $material->plan_product_id = $this->getPlanProductID($material->product_primary_id, $year, $month, $site);
                $material->quantity = $this->getQuantity($material->product_primary_id, $year, $month, $site);
                $material->stock_inh = $this->getStockInH($material->product_primary_id, $year, $month, $site);
                $material->production_requirment = $this->getProductionRequerment($material->product_primary_id, $year, $month);
                $material->re_order_level = $this->getReOrderLeve($material->product_primary_id);
                $material->broaght_forward = $this->getBroaghtForward($material->product_primary_id, $year, $month, $site);
                $material->requirment = $this->getRequirment($material->product_primary_id, $year, $month, $site);
            }

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "mainRawMaterials", $materials);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "mainRawMaterials", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    function getQuantity($product_id, $year, $month, $site)
    {
        $qty = 0;
        $productPlan = PlanProduct::where([['product_primary_id', '=', $product_id], ['year', '=', $year], ['month', '=', $month], ['site_id', '=', $site]])->first();
        if ($productPlan) {
            $qty = $productPlan->quantity;
        }
        return $qty;
    }

    function getStockInH($product_id, $year, $month, $site)
    {
        $qty = 0;
        $productPlan = PlanProduct::where([['product_primary_id', '=', $product_id], ['year', '=', $year], ['month', '=', $month], ['site_id', '=', $site]])->first();
        if ($productPlan) {
            $qty = $productPlan->stock_in_h;
        }
        return $qty;
    }

    function getBroaghtForward($product_id, $year, $month, $site)
    {
        $qty = 0;
        $productPlan = PlanProduct::where([['product_primary_id', '=', $product_id], ['year', '=', $year], ['month', '=', $month], ['site_id', '=', $site]])->first();
        if ($productPlan) {
            $qty = $productPlan->broaght_forward;
        }
        return $qty;
    }


    function getPlanProductID($product_id, $year, $month, $site)
    {
        $id = 'undefined';
        $productPlan = PlanProduct::where([['product_primary_id', '=', $product_id], ['year', '=', $year], ['month', '=', $month], ['site_id', '=', $site]])->first();
        if ($productPlan) {
            $id = $productPlan->plan_product_id;
        }
        return $id;
    }


    function getRequirment($product_id, $year, $month, $site)
    {
        $qty = 0;
        $productPlan = PlanProduct::where([['product_primary_id', '=', $product_id], ['year', '=', $year], ['month', '=', $month], ['site_id', '=', $site]])->first();
        if ($productPlan) {
            $qty = $productPlan->requirment;
        }
        return $qty;
    }

    function getProductionRequerment($product_id, $year, $month)
    {
        $qty = DB::table('pp_machinery_plans')->where('pp_machinery_plans.product_primary_id', '=', $product_id)->whereYear('pp_machinery_plans.date', '=', $year)->whereMonth('pp_machinery_plans.date', '=', $month)->sum('pp_machinery_plans.quantity');
        return $qty;
    }


    function getReOrderLeve($product_id)
    {

        $qty = 0;
        $product = Product::find($product_id);
        if ($product) {
            $qty = $product->reorder_level;
        }
        $qty = 10;
        return $qty;
    }



    public function savePlanProduct(Request $request)
    {

        try {
            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);
                if ($dd->plan_product_id == 'undefined') {
                    if ($dd->quantity > 0) {
                        $planProduct = new PlanProduct();
                        $planProduct->site_id = $dd->site_id;
                        $planProduct->product_primary_id = $dd->product_id;
                        $planProduct->quantity = $dd->quantity;
                        $planProduct->stock_in_h = $dd->stock_in_h;
                        $planProduct->production_requirment = $dd->production_requirment;
                        $planProduct->re_order_level = $dd->re_order_level;
                        $planProduct->broaght_forward = $dd->broaght_forward;
                        $planProduct->requirment = $dd->requirment;
                        $planProduct->year = $dd->year;
                        $planProduct->month = $dd->month;
                        $planProduct->save();
                    }
                } else {
                    $planProduct = PlanProduct::find($dd->plan_product_id);
                    $planProduct->site_id = $dd->site_id;
                    $planProduct->product_primary_id = $dd->product_id;
                    $planProduct->quantity = $dd->quantity;
                    $planProduct->stock_in_h = $dd->stock_in_h;
                    $planProduct->production_requirment = $dd->production_requirment;
                    $planProduct->re_order_level = $dd->re_order_level;
                    $planProduct->broaght_forward = $dd->broaght_forward;
                    $planProduct->requirment = $dd->requirment;
                    $planProduct->year = $dd->year;
                    $planProduct->month = $dd->month;
                    $planProduct->update();
                }
            }

            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "savePlanProduct", true);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "savePlanProduct", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }




    function fieldOfficers($plan_product_id)
    {
        try {
            $fieldOfficers = Employee::where([['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5'], ['designation_id', '=', '30']])->get();
            foreach ($fieldOfficers as $field_officer) {
                $field_officer->plan_product_employee_id = $this->fieldOfficerPlanProductEmployeeID($field_officer->employee_id, $plan_product_id);
                $field_officer->quantity = $this->fieldOfficerQuantity($field_officer->employee_id, $plan_product_id);
            }
            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "fieldOfficers", $fieldOfficers);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "fieldOfficers", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }


    function fieldOfficerPlanProductEmployeeID($field_officer_id, $plan_product_id)
    {
        $id = 'undefined';
        $planProduct = PlanProductEmployee::where([['field_officer_id', '=', $field_officer_id], ['plan_product_id', '=', $plan_product_id]])->first();
        if ($planProduct) {
            $id = $planProduct->plan_product_employee_id;
        }
        return $id;
    }

    function fieldOfficerQuantity($field_officer_id, $plan_product_id)
    {
        $qty = 0;
        $planProduct = PlanProductEmployee::where([['field_officer_id', '=', $field_officer_id], ['plan_product_id', '=', $plan_product_id]])->first();
        if ($planProduct) {
            $qty = $planProduct->quantity;
        }
        return $qty;
    }



    public function saveFieldOfficerQuantity(Request $request)
    {

        try {
            $data = $request->get("data");
            for ($i = 0; $i < count($data); $i++) {
                $dd = json_decode($data[$i]);
                $field_officer_id = $dd->field_officer_id;
                $quantity =  $dd->quantity;
                $product_primary_id =  $dd->product_primary_id;
                $plan_product_id =  $dd->plan_product_id;

                if ($dd->plan_product__employee_id == 'undefined') {
                    $planProduct = new PlanProductEmployee();
                    $planProduct->plan_product_id = $plan_product_id;
                    $planProduct->product_primary_id = $product_primary_id;
                    $planProduct->field_officer_id = $field_officer_id;
                    $planProduct->quantity = $quantity;
                    $planProduct->save();
                } else {
                    $planProduct = PlanProductEmployee::find($dd->plan_product__employee_id);
                    $planProduct->plan_product_id = $plan_product_id;
                    $planProduct->product_primary_id = $product_primary_id;
                    $planProduct->field_officer_id = $field_officer_id;
                    $planProduct->quantity = $quantity;
                    $planProduct->update();
                }
            }




            $responseBody = $this->responseBody(true, "PlanProductEmployeeController", "saveFieldOfficerQuantity", ["product_primary_id" => $product_primary_id, "plan_product_id" => $plan_product_id]);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "PlanProductEmployeeController", "saveFieldOfficerQuantity", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
