<?php

namespace Modules\Fo\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Modules\Fo\Entities\EmployeeSupplyPlan;
use Modules\Fo\Entities\EmployeeSupplyCollection;
use Modules\Fo\Entities\SupplierMaterial;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
// use App\Models\suppliers;
use App\Models\town;
use App\Models\employees;
use Modules\Hr\Entities\Employee;
use Modules\St\Entities\Suppliers;

class Supply_planController extends Controller
{

    // Get All Suppliers
    function GetSuppliers()
    {
        /*try{
            $suplier=new Suppliers();

            $result = $suplier->all();

            // $result = DB::table('st_suppliers')->get();

            $responseBody = $this->responseBody(true, "Suppliers", "Found", $result);

        } catch(\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers", "Error", $exception);
        }

        return response()->json(["data" => $responseBody]);*/
        // return "response";

        //code was commented by the previous deceloper function by nipuna start

        try {

            $Suppliers = new Suppliers();
            $Suppliers = $Suppliers->all();


            $Suppliers_array = [];
            for ($i = 0; $i < count($Suppliers); $i++) {
                array_push($Suppliers_array, ["img" => $Suppliers[$i]['photo_parth'], "id" => $Suppliers[$i]['supplier_id'], "value" =>  $Suppliers[$i]['supplier_name']]);
            }

            $responseBody = $this->responseBody(true, "GetSuppliers", "Found", $Suppliers_array);
        } catch (\Exception $exception) {

            $responseBody = $this->responseBody(false, "GetSuppliers", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);

        //function by nipuna ends
    }
    //by nipuna start
    // function Getpreviousdata($date){
    //     try{

    //         $previousdata = DB::table('fo_employee_supply_plans')
    //             ->where('trans_date', $date)
    //             ->get();
    //         $responseBody = $this->responseBody(true, "previous data", "All", $previousdata);

    //     } catch(\Exception $exception) {
    //         $responseBody = $this->responseBody(false, "previous data", "Error", $exception);
    //     }
    //     return response()->json([ "data" => $responseBody ]);
    // }
    //by nipuna ends

    function InsertSupplyPlan(Request $request)
    {
        try {
            $data = $request->get('all_data');
            $objects  = []; //by nipuna
            for ($i = 0; $i < sizeof($data); $i++) {
                // $object  = [
                //     'supplier_id' => $data[$i]['supplier'],
                //     'product_id' => $data[$i]['product'],
                //     'trans_date' => $data[$i]['date'],
                //     'quantity' => $data[$i]['quantity']
                // ];

                //modification by nipuna start
                array_push($objects, [
                    'employee_id' => $data[$i]['employee_id'],
                    'supplier_id' => $data[$i]['supplier'],
                    'product_id' => $data[$i]['product'],
                    'trans_date' => $data[$i]['date'],
                    'quantity' => $data[$i]['quantity']
                ]);
            }

            // $save = EmployeeSupplyPlan::insert($object);
            foreach ($objects as $object) {
                $save = DB::table('fo_employee_supply_plans')->insert([
                    'supplier_id' => $object
                ]);
            }
            //modification by nipuna end

            // $save = DB::table('fo_employee_supply_plans')->insert([
            //     'supplier_id'=>$object
            // ]);


            if ($save) {
                $responseBody = $this->responseBody(true, "EmployeeSupplyPlan", "upserted", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeSupplyPlan", "Failed", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetSupplyPlan()
    {
        try {
            $result = DB::table('fo_employee_supply_plans')
                ->join('st_suppliers', 'fo_employee_supply_plans.supplier_id', '=', 'st_suppliers.supplier_id')
                ->select('fo_employee_supply_plans.*', 'st_suppliers.supplier_name')
                ->groupBy('fo_employee_supply_plans.trans_date', 'fo_employee_supply_plans.supplier_id')->get();

            $responseBody = $this->responseBody(true, "Suppliers", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Suppliers", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetSupplyPlanData($id)
    {
        try {
            $result = DB::table('fo_employee_supply_plans')
                ->join('st_suppliers', 'fo_employee_supply_plans.supplier_id', '=', 'st_suppliers.supplier_id')
                ->join('st_products', 'fo_employee_supply_plans.product_id', '=', 'st_products.product_id')
                ->where('fo_employee_supply_plans.employee_supply_plan_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "SupplyPlanData", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SupplyPlanData", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetAssignedProducts($id)
    {
        try { //$result = DB::table('employee_supply_plans')->join('products', 'employee_supply_plans.product_id', '=', 'products.product_id')->where('employee_supply_plans.supplier_id', '=', $id)->get();
            $result = DB::table('st_products')->where('product_id', '=', $id)->get();

            $responseBody = $this->responseBody(true, "AssignedProducts", "Got", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AssignedProducts", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function UpdateSupplyPlan(Request $request)
    {
        try {
            foreach ($request->primary_ids as $key => $value) {
                $data = array(
                    'supplier_id' => $request->suppliers[$key],
                    'product_id' => $request->products[$key],
                    'trans_date' => $request->dates[$key],
                    'quantity' => $request->quantities[$key],
                );
                $save = EmployeeSupplyPlan::where('employee_supply_plan_id', $request->primary_ids[$key])
                    ->update($data);
            }

            if ($save) {
                $responseBody = $this->responseBody(true, "SupplyPlan", "Updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SupplyPlan", "UpdatingError", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetProductsOnDate(Request $request)
    {
        try {
            $date = $request->get('date');
            $supplier = $request->get('supplier_id');

            //quary by nipuna
            $result = DB::table('fo_supplier_materials')
                ->where('fo_supplier_materials.supplier_id', '=', $supplier)
                ->join('st_products', 'fo_supplier_materials.product_Id', '=', 'st_products.product_id')
                ->leftJoin('fo_employee_supply_plans', function ($join) use ($date, $supplier) {
                    $join->on('fo_employee_supply_plans.product_id', '=', 'fo_supplier_materials.product_id')
                        ->where('fo_employee_supply_plans.supplier_id', '=', $supplier)
                        ->where('fo_employee_supply_plans.trans_date', '=', $date);
                })->get();

            //quary given by sir

            // $result = DB::statement('SELECT SM.product_Id,P.product_name , IFNULL(SP.quantity,0)
            //                         FROM  (SELECT product_Id  FROM  fo_supplier_materials ) SM
            //                         INNER JOIN  st_products P ON SM.product_Id=P.product_id
            //                         LEFT JOIN ( SELECT product_id , quantity   FROM fo_employee_supply_plans where  ) SP ON SP.product_id=SM.product_Id  ');

            $responseBody = $this->responseBody(true, "ProductsOnDate", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "ProductsOndate", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    function GetSupplierAddress($id)
    {
        try {
            $address = DB::table('st_suppliers')->where('supplier_id', '=', $id)->get();

            $assignedProducts = DB::table('fo_supplier_materials')
                ->join('st_products', 'fo_supplier_materials.product_Id', '=', 'st_products.product_id')
                ->where('fo_supplier_materials.supplier_id', '=', $id)->get();


            $responseBody = $this->responseBody(true, "Supplier_Address", "Found", ["address" => $address, "assignedProducts" => $assignedProducts]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Supplier_Aess", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    // sampath //
    public function allFieldOfficer()
    {
        try {
            $field_officer = Employee::where('designation_id', '=', '30')->get();

            $field_officer_id = [];
            $field_officer_name = [];
            foreach ($field_officer as $officer) {
                array_push($field_officer_id, ["img" => $officer['photo_parth'], "id" => $officer['employee_id'], "value" => $officer['employee_id']]);
                array_push($field_officer_name, ["img" => $officer['photo_parth'], "id" => $officer['employee_id'], "value" => $officer['name_withinitial']]);
            }

            $responseBody = $this->responseBody(true, "FieldOfficer", "all", ["id" => $field_officer_id, "name" => $field_officer_name]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FieldOfficer", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function isFieldOfficer($id)
    {
        try {
            $employee = Employee::find($id);
            $bool = false;
            if ($employee->designation_id == '30') {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "FieldOfficer", "is_fieldOfficer", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "FieldOfficer", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function getEmployeeByID($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    function GetSupplierPlanList($id, $start_date, $end_date)
    {
        try {
            /*$result = DB::table('fo_employee_supply_collections')
                ->join('st_suppliers', 'fo_employee_supply_collections.supplier_id', '=', 'st_suppliers.supplier_id')
                ->select('fo_employee_supply_collections.*', 'st_suppliers.supplier_name')
                ->groupBy('fo_employee_supply_collections.trans_date', 'fo_employee_supply_collections.supplier_id')->get();*/

            $query = "SELECT
                fo_employee_supply_plans.`employee_supply_plan_id` AS plan_id,
                st_suppliers.`supplier_name` AS supplier_name,
                st_suppliers.`supplier_id` AS supplier_id,
                fo_employee_supply_plans.`trans_date` AS trans_date
           FROM
                `fo_employee_supply_plans` fo_employee_supply_plans INNER JOIN `st_suppliers` st_suppliers ON fo_employee_supply_plans.`supplier_id` = st_suppliers.`supplier_id` WHERE fo_employee_supply_plans.`employee_id` = '" . $id . "' AND fo_employee_supply_plans.`trans_date` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";

            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "SupplyPlan", "Found", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SupplyPlan", "Error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "name" => $name,
            "message" => $message,
            "result" => $result
        ];
        return $body;
    }
}
