var events = [];

$(document).ready(function () {
    $('#calendar-demo').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listMonth'
        },
        editable: true,
        droppable: true,
        drop: function () {
            $(this).remove();

        },
        weekNumbers: true,
        eventLimit: false, // allow "more" link when too many events
        dayClick: function () {
            $('#createEventModal').modal();

        },
        eventClick: function (event, jsEvent, view) {
            var employee_id = event.description.employee_id;
            var date = event.description.date;
            // alert(employee_id);
            // alert(date);
            $.ajax({
                type: 'POST',
                url: '/fo/FieldOperation/GetSuppplyPlanDataToModal',
                headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                },
                data: {
                    "employee_id" : employee_id,
                    "date" : date,
                },
                success: function(response) {
                    console.log(response);
                    var html = "";
                    html += '<table class="table table-striped">';
                    html += '<thead>';
                    html += '<tr>';
                    html += '<th>Product Name</th> <th>Quantity</th>';
                    html += '</tr>';
                    html += '</thead>';
                    $.each(response.data.result, function(index, value) {
                        html += '<tbody>';
                        html += '<tr>';
                        html += '<td>' +value.product_name+ '</td>';
                        html += '<td>' +value.quantity+ '</td>';
                        html += '</tr>';
                        html += '</tbody>';
                    })
                    html += '</table>';
                    modal.find('.event-body').html(html);
                }, error: function(data) {
                    console.log('Something went wrong!');
                }
            })
            var modal = $('#viewEventModal');
            modal.find('.event-icon').html("<i class='fa fa-" + event.icon + "'></i>");
            modal.find('.event-title').html(event.title + "  ON  " +event.description.date);
            modal.modal();
        },
    });
});




function addShedule(shift_id, supplier_name, date, date, plan_quantity, product_name, employee_id) {
    var R = (parseInt(shift_id) *  215);
    if (R > 255) R = (R - 255);
    var G = (parseInt(shift_id) * 100);
    if (G > 255) R = (G - 255);
    var B = (parseInt(shift_id) * 50);
    if (B > 255) R = (B - 255);

    events.push({
        title: supplier_name,
        start: date,
        end: date,
        backgroundColor: 'rgb(' + R + ',' + G + ',' + B + ')',
        icon: "building-o",
        description: {"employee_id": employee_id, "date": date},
    });

}


function clearCalander() {
    $('#calendar-demo').fullCalendar('removeEvents');
    events = [];
}


function createCalendar() {
    $('#calendar-demo').fullCalendar('removeEvents');
    $('#calendar-demo').fullCalendar('addEventSource', events);

}
