// LoadSupplierVist();

const SAVE = "save";
const UPDATE = "update";
//by nipuna start
// 20010
var userId =uid; //created by nipuna | equal to session user id variable remove later
var designation_id =0;
if (userId!=null){
    designation_id = getDesignationId(userId);
    // console.log(designation_id);
}
//by nipuna ends
const TITLE_MAP = {
    'savesupplier': 'Assign A New Supplier',
    'updatesupplier': 'Update Supplier',
    'savesupplierVisit': 'Create A New Supplier Visit',
    'updatesupplierVisit': 'Update Supplier Visit',
};

var start = moment().subtract(29, 'days');
var end = moment();
var id;

function cb(start, end) {
    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    var start_date = new Date(start);
    var end_date = new Date(end);

    var str_start = start_date.getFullYear() + "-" + (((start_date.getMonth() + 1) > 9 ? '' : '0') + (start_date.getMonth() + 1)) + "-" + ((start_date.getDate() > 9 ? '' : '0') + start_date.getDate());
    var str_end = end_date.getFullYear() + "-" + (((end_date.getMonth() + 1) > 9 ? '' : '0') + (end_date.getMonth() + 1)) + "-" + ((end_date.getDate() > 9 ? '' : '0') + end_date.getDate());



     console.log(str_start +' - '+str_end);//nipuna
    // var designation_id=getDesignationId(userId);
    //by nipuna start
    if(userId>=0 && designation_id==30){
        $('#hidEmployeeID').val(userId);
        // loadOfficer(userId);
        // LoadSupplierVisitByOfficer(userId);
        filterToDateByOfficer(str_start, str_end,userId);
    }
    else{

        filterToDate(str_start, str_end);//nipuna

    }
    //by nipuna end

}

$('#dashboard-daterangepicker').daterangepicker({
    startDate: start,
    endDate: end,
    opens: $('body').hasClass('rtl') ? 'right' : 'left',
    ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
}, cb);

cb(start, end);



$(document).ready(function() {
    // Load field Officers To Auto Complete
    // alert(getDesignationId(userId));
    $('#tblSupplierPlan').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "supplier" },
            { "data": "arrived_on" },
            { "data": "depature_on" },
            { "data": "observation" },
            { "data": "edit", className: "edit"  },
        ],
    });

    //by nipuna start
    checkUser();

    function checkUser(data){
        // alert(userId);
        // var empId=getEmpId(userId);

        // var designation_id=getDesignationId(userId);
        if(userId>0 && designation_id==30){

            $.ajax({
                type: 'GET',
                url: '/fo/FieldOperation/GetSingleFiledOfficer/'+userId,
                success: function(response) {
                    // console.log(response);
                    if (response.data.success) {
                        $('#FieldOfficer_combo').val(userId);
                        $('#auto-comp2').val(response.data.result.name_withinitial);

                        $('#hidEmployeeID').val(userId);

                        loadOfficer(userId);
                        LoadSupplierVisitByOfficer(userId);

                        // console.log('ok');
                        // console.log(response.data.result[0].id);
                        //edited by nipuna
                    }

                }, error: function(data) {
                    console.log(data) ;
                    console.log('Something went wrong!');
                }
            })
        }
        else{
            LoadFieldOfficers();
            LoadOfficerNames();
            LoadSupplierVist();
        }
    }
    document.getElementById("btnAssignSupplier").disabled = true;
    // $('#btnAssignSupplier').disabled = true;
    //by nipuna end



})

function getDesignationId(id){
    var des_id = 0;
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/getDesignationId/'+id,
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        success: function(response) {

           if(response.data.success) {
               if(response.data.result){
                 des_id =response.data.result.designation_id;

               }
           }
        }, error: function (data) {
            des_id =0;
        }
    });
    return des_id;
}
function LoadFieldOfficers() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetSupplierId',
        success: function(response) {
            // console.log(response);

            if(response.data.success) {
                console.log(response.data.result);
                $('#FieldOfficer_combo').setData(response.data.result);
                // console.log(response.data.result[0].name);

            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}

function LoadOfficerNames() {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetFieldOfficerName',
        success: function(response) {
            // console.log(response);
            if (response.data.success) {
                $('#auto-comp2').setData(response.data.result);
                // console.log('ok');
                // console.log(response.data.result[0].id);
                //edited by nipuna
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}

function showModal(event, name, id) {
    var title = TITLE_MAP[event + name];
    console.log(event);
    console.log(name);

    $('#settingsAddModalTitle').text(title);
    if (event == SAVE) {
        LoadSupplierData();
        $('#btnAssignSupplier').text("Save");
        $('#divDepature').hide();
        $('#divObservation').hide();
        GetLocation();
    }


    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();

    var Ontoday = yyyy + '-' + mm + '-' + dd;
    var Ontime = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
    console.log(Ontoday);
    console.log(Ontime);
    $('#arrivedOn').val(Ontoday);


    $('#supplierAssignModal').modal('toggle');
}
// Get data to update modal
function GetSupplierVisitDataToModal(supplier_visit_id) {
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/GetsupplierVisitDataToModal/' + supplier_visit_id,
        success: function(response) {
            console.log(response);

            if (response.data.success) {
                LoadSupplierData();
                var supplier_id = response.data.result[0]['supplier_id'];
                var supplier_name = response.data.result[0]['supplier_name'];
                var arrived_on = response.data.result[0]['arrival'];
                var depature_on = response.data.result[0]['depature'];
                var observation = response.data.result[0]['observation'];
                var supplier_visit_id = response.data.result[0]['supplier_visit_id'];

                $('#arrivedOn').val(arrived_on);
                $('#DepaturedOn').val(depature_on);
                $('#txtObservation').val(observation);
                $('#hidSupplierId').val(supplier_id);
                $('#hidSupVisitId').val(supplier_visit_id);
                $('#selectSupplierName').filter(function(params) {
                    return $(this).text() == supplier_name;
                }).prop('selected', true);


            }

        }, error: function(data) {
            console.log('Something went wrong');
        }
    })
}
// Arrived On button Click
$('#btnArrivedOn').on('click', function(event) {
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();

    var Ontoday = yyyy + '-' + mm + '-' + dd;
    var Ontime = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
    // console.log(Ontoday);
    // console.log(Ontime);
    $('#arrivedOn').val(Ontoday + "_" + Ontime);
    document.getElementById("btnAssignSupplier").disabled = false;

})

// Depature Button
$('#btnDepaturedOn').on('click', function() {
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();

    var Ontoday = yyyy + '-' + mm + '-' + dd;
    var Ontime = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();

    $('#DepaturedOn').val(Ontoday + "_" + Ontime);
})


// Create new supplier visit
$('#btnAssignSupplier').on('click', function() {

    if($('#btnAssignSupplier').text()  == "Save")  {
        var arrivedOn = $('#arrivedOn').val();
        var depOn = $('#DepaturedOn').val();
        var supplierId = $('#selectSupplierName').val();
        var employeeId = $('#hidEmployeeID').val();
        var latitude = $('#hidLatitude').val();
        var longitude = $('#hidLongitude').val();

        console.log(arrivedOn);
        console.log(depOn);
        console.log(supplierId);
        console.log(employeeId);
        console.log(latitude);
        console.log(longitude);

        CreateSuuplierVisit(arrivedOn, depOn, supplierId, employeeId, latitude, longitude);


    } else if($('#btnAssignSupplier').text() == "Update") {
        var arrivedOn = $('#arrivedOn').val();
        var depOn = $('#DepaturedOn').val();
        var supplierId = $('#selectSupplierName').val();
        var employeeId = $('#hidEmployeeID').val();
        var observation = $('#txtObservation').val();
        var supplier_visit_id = $('#hidSupVisitId').val();
        UpdateSupplierVisit(arrivedOn, depOn, supplierId, employeeId, observation, supplier_visit_id);
    }
})

function GetLocation() {
    if(navigator.geolocation){
        navigator.geolocation.getCurrentPosition(showPosition);
    } else {
        toastr.error('This action requires location access!');
    }
}

function showPosition(position) {
    console.log(position.coords.latitude);
    console.log(position.coords.longitude);
    // Set lattitude
    $('#hidLatitude').val(position.coords.latitude);
    $('#hidLongitude').val(position.coords.longitude);
}

function CreateSuuplierVisit(arrivedOn, depOn, supplierId, employeeId, latitude, longitude) {

    $.ajax({

        type: 'POST',
        url: '/fo/SupplierVisit/createSupplierVisit',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            },
        data: {
            "employee_id": employeeId,
            "arrived_on": arrivedOn,
            "depature_on": depOn,
            "supplier_id": supplierId,
            "latitude": latitude,
            "longitude": longitude

        },
        success: function(response) {
            console.log(response);

            if (response.data.success) {
                toastr.success('Supplier Visit Created Successfully!');
                $('#supplierAssignModal').modal('hide');
                LoadSupplierVisitByOfficer(response.data.result);
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}

// Update Supplier Visit
function UpdateSupplierVisit(arrivedOn, depOn, supplierId, employeeId, observation, supplier_visit_id) {
    $.ajax({
        type: 'POST',
        url: '/fo/SupplierVisit/UpdateSupplierVisit/' + supplier_visit_id,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            },
        data: {
            "arrived_on": arrivedOn,
            "depature_on": depOn,
            "supplier_id": supplierId,
            "observation": observation,
            "employee_id": employeeId,
        },
        success: function(response) {
            console.log(response);

            if(response.data.success) {
                toastr.success('Supplier Visit Updated!');
                $('#supplierAssignModal').modal('hide');
                if (response.data.result == 1) {
                    LoadSupplierVist();
                }
                LoadSupplierVisitByOfficer(response.data.result);
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}

// Load Field Officers
function LoadSupplierVist() {
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/LoadSupplierVisit',
        success: function (response) {
            console.log(response);
            //appendDataOnTable(response.data.result);

            if (response.data.success) {

                loadMap(response.data.result);//nipuna

                var data = [];
                    for (i = 0; i < response.data.result.length; i++) {

                        var supplier_visit_id = response.data.result[i]['supplier_visit_id'];
                        var supplier_name = response.data.result[i]['supplier_name'];
                        var arrived_on = response.data.result[i]['arrival'];
                        var depature_on = response.data.result[i]['depature'];
                        var observation = response.data.result[i]['observation'];
                        $('#hidSupVisitId').val(supplier_visit_id);

                        data.push({
                            "supplier" : supplier_name,
                            "arrived_on" : arrived_on,
                            "depature_on" : depature_on,
                            "observation" : observation,
                            "edit": '<button class="btn btn-primary" onclick="Edit(' + supplier_visit_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        });
                    }

                    var table = $('#tblSupplierPlan').DataTable();
                    table.clear();
                    table.rows.add(data).draw();

            }

        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}

function Edit(id) {
    //console.log(id);
    var title = TITLE_MAP['update'+'supplierVisit'];
    //console.log(title);
    $('#settingsAddModalTitle').text(title);
    $('#divDepature').show();
    $('#divObservation').show();
    $('#btnAssignSupplier').text("Update");
    GetSupplierVisitDataToModal(id);

    $('#supplierAssignModal').modal('toggle');

}

// Load supplier data in to bootstrap modal
function LoadSupplierData() {
    $.ajax({
        type: 'GET',
        url: '/fo/EmployeeSupplier/getAllSuppliers',
        success: function(response) {
            console.log(response);
            var html = '';
            if (response.data.success) {
                $.each(response.data.result, function(index, value) {
                    html += '<option value="' +value.supplier_id+ '">' +value.supplier_name+ '</option>';
                    //console.log(html);
                })
                $('#selectSupplierName').html(html);
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}






// This function is override from autoCompleteSelectedOption.min.js
function autoCompleteSelectedOption(input, data) {
    console.log(data.id);
    $('#hidEmployeeID').val(data.id);
    loadOfficer(data.id);
    // checkUser(data.id)
    clearCalander();
    LoadSupplierByOfficer(data.id);
    LoadSupplierVisitByOfficer(data.id);

    loadMatchingIdName(input,data);
}

//wrote by nipuna theekshana
//start
function loadMatchingIdName(input,data){

    if(input.id=='auto-comp2'){
        $('#FieldOfficer_combo').val(data.id);
    }
    else if(input.id=='FieldOfficer_combo'){

        $('#auto-comp2').val('');

        $.ajax({
            type: 'GET',
            url: '/fo/FieldOperation/getFieldOfficerNametoId/' + data.id,
            success: function (response) {
                console.log(response.data.result.name_withinitial);

                console.log('ok');
                $('#auto-comp2').val(response.data.result.name_withinitial);

            }, error: function (data) {
                console.log('Something went wrong!');
            }
        })
        // $('#auto-comp2').val(data.name);

    }
    // console.log('ok');


    // console.log(data.name);
}

function loadMap(data){

    var markers=[];
    // console.log(data);

    for (i = 0; i < data.length; i++) {


        var latt =data[i]['latitude'];
        var long =data[i]['longitude'];

        markers.push({
            'latitude':latt,
            'longitude':long
        });
    }
    // console.log(markers);
    initMap(markers);
}

function filterToDate(St_date, End_date){

    var data = { "St_date": St_date,"End_date": End_date}
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/GetSupplierVisitByDate',
        data: data,
        dataType: "json",
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                loadMap(response.data.result);

                var data = [];
                    for (i = 0; i < response.data.result.length; i++) {
                        var supplier_visit_id = response.data.result[i]['supplier_visit_id'];
                        var supplier_name = response.data.result[i]['supplier_name'];
                        var arrived_on = response.data.result[i]['arrival'];
                        var depature_on = response.data.result[i]['depature'];
                        var observation = response.data.result[i]['observation'];
                        $('#hidSupVisitId').val(supplier_visit_id);

                        data.push({
                            "supplier" : supplier_name,
                            "arrived_on" : arrived_on,
                            "depature_on" : depature_on,
                            "observation" : observation,
                            "edit": '<button class="btn btn-primary" onclick="Edit(' + supplier_visit_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        });
                    }

                   //table
                   var table = $('#tblSupplierPlan').DataTable();
                    table.clear();
                    table.rows.add(data).draw();
            }

        }, error: function(data) {
            console.log('Something Went Wrong');
        }
    })
}
function filterToDateByOfficer(St_date, End_date,id){

    var data = { "St_date": St_date,"End_date": End_date, }
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/GetSupplierVisitByDateToOfficer/'+id,
        data: data,
        dataType: "json",
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                loadMap(response.data.result);

                var data = [];
                    for (i = 0; i < response.data.result.length; i++) {
                        var supplier_visit_id = response.data.result[i]['supplier_visit_id'];
                        var supplier_name = response.data.result[i]['supplier_name'];
                        var arrived_on = response.data.result[i]['arrival'];
                        var depature_on = response.data.result[i]['depature'];
                        var observation = response.data.result[i]['observation'];
                        $('#hidSupVisitId').val(supplier_visit_id);

                        data.push({
                            "supplier" : supplier_name,
                            "arrived_on" : arrived_on,
                            "depature_on" : depature_on,
                            "observation" : observation,
                            "edit": '<button class="btn btn-primary" onclick="Edit(' + supplier_visit_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        });
                    }

                   //table
                   var table = $('#tblSupplierPlan').DataTable();
                    table.clear();
                    table.rows.add(data).draw();
            }

        }, error: function(data) {
            console.log('Something Went Wrong');
        }
    })
}



//nipuna end

function loadOfficer(employee_id) {
    $.ajax({
        type: 'GET',
        url: '/fo/FieldOperation/GetOfficerNameById/' + employee_id,
        success: function (response) {
            // console.log(response);

            if (response.data.success) {
                var officer = response.data.result[0];
                $('#imgEmployee').attr("src", officer.photo_parth);
                $('#employeeId').val(officer.employee_id);
                $('#FieldOfficer_combo').val(officer.employee_id);
                $('#auto-comp2').val(officer.name_withinitial);
                // console.log(officer);
            }
        }, error: function (data) {
            console.log('Something went wrong!');
        }
    })
}

function LoadSupplierByOfficer(id) {
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/GetSupplierByOfficer/' + id,
        success: function(response) {
            console.log(response);

            if (response.data.success) {
                var html = '';
                $.each(response.data.result, function(index, value) {
                    html += '<option value="' +value.supplier_id+ '">' +value.supplier_name+ '</option>';
                    //console.log(html);
                })
                $('#selectSupplierName').html(html);
            }
        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}

function LoadSupplierVisitByOfficer(id) {
    CreateSupplierVisitSchedule(id);
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/GetSupplierVisitByEmployee/' + id,
        success: function (response) {
            // console.log(response);

            if (response.data.success) {
                var data = [];
                    for (i = 0; i < response.data.result.length; i++) {
                        var supplier_visit_id = response.data.result[i]['supplier_visit_id'];
                        var supplier_name = response.data.result[i]['supplier_name'];
                        var arrived_on = response.data.result[i]['arrival'];
                        var depature_on = response.data.result[i]['depature'];
                        var observation = response.data.result[i]['observation'];
                        $('#hidSupVisitId').val(supplier_visit_id);

                        data.push({
                            "supplier" : supplier_name,
                            "arrived_on" : arrived_on,
                            "depature_on" : depature_on,
                            "observation" : observation,
                            "edit": '<button class="btn btn-primary" onclick="Edit(' + supplier_visit_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        });
                    }

                    // $('#tblSupplierPlan').DataTable({
                    //     destroy: true,
                    //     responsive: true,
                    //     "order": [],
                    //     "data": data,
                    //     "columns": [
                    //         { "data": "supplier" },
                    //         { "data": "arrived_on" },
                    //         { "data": "depature_on" },
                    //         { "data": "observation" },
                    //         { "data": "edit" }
                    //     ],
                    // });
                    var table = $('#tblSupplierPlan').DataTable();
                    table.clear();
                    table.rows.add(data).draw();
            }

        }, error: function(data) {
            console.log('Something Went Wrong');
        }
    })
}

function CreateSupplierVisitSchedule(id) {
    // console.log('CreateSupplierVisitSchedule');
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisit/GetSupplierVisitByEmployeeToCalander/' + id,
        success: function(response) {
            // console.log(response);
            if (response.data.success) {
                var latt = response.data.result[0]['latitude'];
                var long = response.data.result[0]['longitude'];


                // $('#hidLatt').val(latt);
                // $('#hidLong').val(long);
                // initMap(latt, long); //comented by nipuna
                loadMap(response.data.result); //by nipuna

                for(i=0; i < response.data.result.length; i++) {
                    var date = response.data.result[i]['arrival'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var visit_id = response.data.result[i]['supplier_visit_id'];
                    var employee_id = response.data.result[i]['employee_id'];
                    var arrival = response.data.result[i]['arrival'];
                    var newDate = date.substring(0,10);
                    // console.log(newDate);
                    addShedule(visit_id, supplier_name, newDate, newDate, employee_id, arrival);
                }
                createCalendar();
            }

        }, error: function(data) {
            console.log('Something went wrong!');
        }
    })
}

