$(document).ready(function () {
    console.log('js loading');
    LoadSupplyCollection();
})
$('input[name="txtSupplyDate"]').daterangepicker({
    singleDatePicker: true,
    showDropdowns: true,
    autoUpdateInput: false
}).on('apply.daterangepicker', function (ev, picker) {
    $(this).val(picker.startDate.format('YYYY-MM-DD'));
});

function GetSupplierAddressToPlanned(id) {
    console.log(id);
    $.ajax({
        type: 'GET',
        url: '/fo/SupplyCollection/GetSupplierAddressToCollection/' + id,
        success: function (response) {
            console.log(response);
            var address = response.data.result['address'][0]['address'];
            if (response.data.success) {
                $('#txtEmployeeAddress').text(address);
                var html = '';
                $.each(response.data.result.products, function (index, value) {
                    html += '<tr>';
                    html += '<td>' + value.product_name + '</td>';
                    html += '<td style="display:none;">' + value.product_id + '</td>';
                    html += '<td>';
                    html += '<label class="label-default">' + value.reorder_quantity + '</label>';
                    html += '</td>';
                    html += '<td>' + value.quantity + '</td>';
                    html += '<td>';
                    html += '<input type="text" class="form-control" id="myInput"></input>';
                    html += '</td>';
                    html += '</tr>';
                });
                $('#tbodyPlannedMaterials').html(html);
            }
        }, error: function (data) {
            console.log('Something went wrong..!');
        }
    });
}


$('#btnEmployeeSupplyCollection').on('click', function () {
    if ($('#btnEmployeeSupplyCollection').text() == "Submit") {
        var all_data = [];
        var supplier_id = $('#hidSupplierID').val();
        var date = $('#txtSupplyDate').val();
        var colllectionTblData = $('#supplyCollectionTbl tr:has(td)').map(function (i, v) {
            var $td = $('td', this);
            return {
                product_id: $td.eq(1).text(),
                collection: $(this).find("td:eq(4) input[type='text']").val()
            }
        }).get();
        //console.log(colllectionTblData);
        colllectionTblData.forEach(function (element) {
            if (element['quantity'] <= 0) {
                toastr.error('null value!');
            } else {
                all_data.push({ "employee_id": uid, "products": element['product_id'], "quantities": element['collection'], "supplier": supplier_id, "date": date });
            }
        });
        //console.log(all_data);

        $.ajax({
            type: 'POST',
            url: '/fo/SupplyCollection/SaveSupplyCollection',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            },
            data: {
                "all_data": all_data,
            },
            success: function (response) {
                console.log(response);
                if (response.data.success) {
                    toastr.success('Success..!');
                    $('#txtSupplyDate').val('');
                    $('#txtSupplier3').val('');
                    $('#txtEmployeeAddress').text('');
                    $('#tbodyPlannedMaterials').text('');
                }
            }, error: function (data) {
                console.log('something went wrong!');
            }
        });
    } else if ($('#btnEmployeeSupplyCollection').text() == "Update") {
        Update();
    }

})

function LoadSupplyCollection() {
    if (window.location.search.length > 0) {
        var id = window.location.search.substring(1);
        //console.log(id);
        $('#btnEmployeeSupplyCollection').text('Update');

        $.ajax({
            type: 'GET',
            url: '/fo/SupplyCollectionController/GetSupplyCollectionData/' + id,
            success: function (response) {
                console.log(response);
                var html = '';
                var date = response.data.result[0]['trans_date'];
                var supplier_name = response.data.result[0]['supplier_name'];
                var address = response.data.result[0]['address'];
                var supplier_id = response.data.result[0]['supplier_id'];
                var supplier_collection_id = response.data.result[0]['employee_supply_collection_id'];

                $('#hidSupplierID').val(supplier_id);
                $('#hidSupCollectionId').val(supplier_collection_id);

                $('#txtSupplyDate').val(date);
                $('#txtSupplier3').val(supplier_name);
                $('#txtEmployeeAddress').val(address);
                LoadProductsOnDateToSupplyCollection(supplier_id, date);
            }, error: function (data) {
                console.log('Something went wrong!');
            }
        });
    }
}

function LoadProductsOnDateToSupplyCollection(supplier_id, date) {
    console.log('testing');
    $.ajax({
        type: 'POST',
        url: '/fo/SupplyCollection/GetProductsOnDateToSupplyCollection',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        },
        data: {
            "supplier_id": supplier_id,
            "date": date
        },
        success: function (response) {
            console.log(response);
            html = '';
            $.each(response.data.result, function (index, value) {
                html += '<tr>';
                html += '<td>' + value.product_name + '</td>';
                html += '<td style="display:none;">' + value.product_id + '</td>';
                html += '<td>';
                html += '<label class="label-default">' + value.reorder_quantity + '</label>';
                html += '</td>';
                html += '<td>' + value.quantity + '</td>';
                html += '<td>';
                html += '<input type="text" class="form-control" id="myInput" value="' + value.collection_quantity + '"></input>';
                html += '</td>';
                html += '<td style="display:none;">' + value.employee_supply_collection_id + '</td>'
                html += '</tr>';
            });
            $('#tbodyPlannedMaterials').html(html);
        }, error: function (data) {
            console.log('Something Went Wrong!');
        }
    });
}

function Update() {
    var supplier_id = $('#hidSupplierID').val();
    var date = $('#txtSupplyDate').val();
    var all_data = [];
    var products = [];
    var primary_ids = [];
    var quantities = [];
    var suppliers = [];
    var dates = [];

    var updateTbldata2 = $('#supplyCollectionTbl tr:has(td)').map(function (i, v) {
        var $td = $('td', this);
        return {
            product_id: $td.eq(1).text(),
            quantity: $(this).find("td:eq(4) input[type='text']").val(),
            primary_id: $td.eq(5).text(),
        }
    }).get();
    //console.log(updateTbldata2);

    updateTbldata2.forEach(function (element) {
        all_data.push({ "products": element['product_id'], "primary_id": element['primary_id'], "quantity": element['quantity'], "supplier": supplier_id, "date": date });
    });
    console.log(all_data);
    all_data.forEach(function (element) {
        products.push(element['products']);
        primary_ids.push(element['primary_id']);
        quantities.push(element['quantity']);
        suppliers.push(element['supplier']);
        dates.push(element['date']);
    })
    // console.log(products);
    // console.log(primary_ids);
    // console.log(quantities);
    // console.log(suppliers);
    // console.log(dates);
    $.ajax({
        type: 'POST',
        url: '/fo/SupplyCollection/UpdateSupplyCollection',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
        },
        data: {
            "products": products,
            "primary_ids": primary_ids,
            "quantities": quantities,
            "suppliers": suppliers,
            "dates": dates
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('Update Success!');
            } else {
                toastr.error('Update Failed!');
            }
        }, error: function (data) {
            console.log('Something went wrong');
        }
    });
    
}
