
var ACTION = 'save';
var supplierChooser = null;
$(document).ready(function () {

    var max_year = (parseInt(serverDate().split('/')[0]) + 1);
    var min_year = (max_year - 5);
    for (var i = min_year; i <= max_year; i++) {

        $('#cmbYear').append('<option value="' + i + '">' + i + '</option>');
    }


    setSelectedOption('cmbYear', (max_year - 1));
    setSelectedOption('cmbMonth', serverDate().split('/')[1]);

    sites();
    fieldOfficers();
    suppliers();











    mainRawMaterials($('#cmbOfficer').val());
    getOfficerQuantity($('#cmbOfficer').val(), $('#cmbItem').val(), $('#cmbYear').val(), $('#cmbMonth').val());

    $('#cmbOfficer').on('change', function () {
        mainRawMaterials($(this).val());
        getOfficerQuantity($(this).val(), $('#cmbItem').val(), $('#cmbYear').val(), $('#cmbMonth').val());
    });

    $('#cmbItem').on('change', function () {
        getOfficerQuantity($('#cmbOfficer').val(), $(this).val(), $('#cmbYear').val(), $('#cmbMonth').val());
    });

    $('#cmbYear').on('change', function () {
        getOfficerQuantity($('#cmbOfficer').val(), $('#cmbItem').val(), $(this).val(), $('#cmbMonth').val());
    });

    $('#cmbMonth').on('change', function () {
        getOfficerQuantity($('#cmbOfficer').val(), $('#cmbItem').val(), $('#cmbYear').val(), $(this).val());
    });

    $('#cmbSite').on('change', function () {
        getOfficerQuantity($('#cmbOfficer').val(), $('#cmbItem').val(), $('#cmbYear').val(), $('#cmbMonth').val());
    });



    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var officer_id = param[0].split('=')[1].split('&')[0];
        var site = param[0].split('=')[2].split('&')[0];
        var product_id = param[0].split('=')[3].split('&')[0];
        var year = param[0].split('=')[4].split('&')[0];
        var month = param[0].split('=')[5].split('&')[0];
        ACTION = param[0].split('=')[6].split('&')[0];

        //mainRawMaterials();
        setSelectedOption('cmbOfficer', officer_id);
        setSelectedOption('cmbItem', product_id);
        setSelectedOption('cmbSite', site);
        setSelectedOption('cmbYear', year);
        setSelectedOption('cmbMonth', month);
        getOfficerQuantity($('#cmbOfficer').val(), $('#cmbItem').val(), $('#cmbYear').val(), $('#cmbMonth').val());

        if (ACTION == 'edit') {

        } else if (ACTION == 'view') {
            $('#btnAction').hide();
        }



    }


    $('#btnAction').on('click', function () {

        if ($(this).text() == 'Save') {
            save();
        }
    });

    supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });
    var supplier_data = allSuppliers();
    //console.log(product_data);
    supplierChooser.setDataSource(supplier_data);


    supplierChooser.on('select', function (event, data) {
        var input = supplierChooser.getInput();
        input.focus();

        var supplier_id = data[0];
        var supplier_name = data[1];
        input.attr("data-id", supplier_id);
        input.val(supplier_name);

    });




});

function sites() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductEmployeeDailyController/sites',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#cmbSite').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.site_id + '">' + value.site + '</option>';
                })
                $('#cmbSite').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}



function mainRawMaterials(officer_id) {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductEmployeeDailyController/mainRawMaterials/' + officer_id,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#cmbItem').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.product_primary_id + '">' + value.product_name + '</option>';
                })
                $('#cmbItem').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}



function fieldOfficers() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductEmployeeDailyController/fieldOfficers',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#cmbOfficer').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.employee_id + '">' + value.name_withinitial + '</option>';
                })
                $('#cmbOfficer').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}



function suppliers() {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductEmployeeDailyController/suppliers',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.supplier_id + '">' + value.supplier_name + '</option>';
                })
                $('#cmbSupplier').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function getOfficerQuantity(officer_id, item_id, year, month) {
    $.ajax({
        type: 'GET',
        url: '/fo/PlanProductEmployeeDailyController/getOfficerQuantity/' + officer_id + "/" + item_id + "/" + year + "/" + month,
        async: false,
        success: function (response) {
            console.log(response.data.result);
            if (response.data.success) {

                var qty = parseFloat(response.data.result).toFixed(2);
                if (isNaN(qty)) {
                    qty = 0;
                }

                $('#txtOfficerQuantity').val(qty);
                loadDailyPlan();
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function save() {
    if ($('#cmbSite option:selected').text() == 'Unspecified') {
        showWarningMessage('Invalied site.');
        return;
    }

    $.ajax({
        type: "POST",
        url: '/fo/PlanProductEmployeeDailyController/save',
        data: {
            'data': dataSource(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Saved data.');
                if (ACTION == 'edit') {
                    location.href = "/fo/plan_product_employee_daily_list";
                }
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}




function addRow(id) {
    $('#' + id).text("Remove");
    $('#' + id).attr('class', 'btn btn-danger remove');
    $('#' + id).attr('onclick', '');

    var btn_id = "btnSave" + guidGenerator();
    var txtSupplier_id = "txtSuppier" + guidGenerator();
    var txtQty_id = "txtQty" + guidGenerator();
    var txtDate_id = "txtDate" + guidGenerator();



    var string_id = "'" + btn_id + "'";
    var string_txtSupplier_id = "'" + txtSupplier_id + "'";


    var text = document.createElement("INPUT");
    text.setAttribute("class", "form-control auto-complete");
    text.setAttribute("type", "text");
    text.setAttribute("id", txtSupplier_id);
    text.setAttribute("data-id", null);
    text.setAttribute("oninput", "showSupplierChooser(" + string_txtSupplier_id + ")");

    var row = '<tr id="' + id + '"><td id="td' + id + '"></td>';
    row += '<td><input id="' + txtDate_id + '" type="text" class="form-control-sm" style="width:150px; border:1px solid gray;background:white;" autocomplete="off" name="dteDate"></td>';
    row += '<td><input id="' + txtQty_id + '" type="text" class="form-control-sm" style="width:100px; border:1px solid gray;text-align:right;" ></td>';
    row += '<td><button type="button" id="' + btn_id + '" class="btn btn-primary" onclick="addRow(' + string_id + ')">Add</button></td></tr>';
    $('#tblProductEmployeeDailyBody').append(row);


    $(".remove").click(function () {
        $(this).closest("tr").remove();
    });

    $("#td" + id).append(text);

    $('input[name="dteDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }
    });

    var comp = {
        "btn_id": btn_id,
        "supplier": $('#' + txtSupplier_id),
        "quantity": $('#' + txtQty_id),
        "date": $('#' + txtDate_id),

    };

    return comp;

}


function guidGenerator() {
    var S4 = function () {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    return (S4() + S4());
}



function allSuppliers() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/fo/PlanProductEmployeeDailyController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}





function dataSource() {

    var collection = {};
    var table = document.getElementById('tblProductEmployeeDailyBody'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;



    for (i = 0, j = rows.length; i < j; ++i) {
        var plan_product_id = rows[i].id;
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }



        var data = {
            "site_id": $('#cmbSite').val(),
            "field_officer_id": $('#cmbOfficer').val(),
            "item_id": $('#cmbItem').val(),
            "supplier_id": $('#' + cells[0].childNodes[0].id).attr('data-id'),
            "date": cells[1].childNodes[0].value,
            "quantity": cells[2].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);



    }

    return collection;

};


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function showSupplierChooser(id) {
    supplierChooser.showChooser($('#' + id));
}




function loadDailyPlan() {
    $.ajax({
        type: "GET",
        url: "/fo/PlanProductEmployeeDailyController/loadDailyPlan/" + $('#cmbSite').val() + "/" + $('#cmbYear').val() + "/" + $('#cmbMonth').val() + "/" + $('#cmbOfficer').val() + "/" + $('#cmbItem').val(),
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response.data);
            var result = response.data.result;
            $('#tblProductEmployeeDailyBody').empty();
            if (result.length > 0) {
                var childarray = { "btn_id": 0 };
                for (var i = 0; i < result.length; i++) {

                    childarray = addRow(childarray.btn_id);
                    childarray.supplier.val(result[i].supplier_name);
                    childarray.supplier.attr('data-id', result[i].supplier_id);
                    childarray.date.val(result[i].date);
                    childarray.quantity.val(parseFloat(result[i].quantity).toFixed(2));


                }
                addRow(childarray.btn_id);

            } else {
                addRow();
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
