

var ACTION = 'save';
var supplierChooser = null;
$(document).ready(function () {

    var max_year = (parseInt(serverDate().split('/')[0]) + 1);
    var min_year = (max_year - 5);
    for (var i = min_year; i <= max_year; i++) {

        $('#cmbYear').append('<option value="' + i + '">' + i + '</option>');
    }


    setSelectedOption('cmbYear', (max_year - 1));
    setSelectedOption('cmbMonth', parseInt(serverDate().split('/')[1]));

    fieldOfficers();



    $('#cmbOfficer').on('change', function () {
        loadSavedSupplierVisitPlan($(this).val(), $('#cmbYear').val(), $('#cmbMonth').val());
    });


    $('#cmbYear').on('change', function () {
        loadSavedSupplierVisitPlan($('#cmbOfficer').val(), $(this).val(), $('#cmbMonth').val());
    });

    $('#cmbMonth').on('change', function () {
        loadSavedSupplierVisitPlan($('#cmbOfficer').val(), $('#cmbYear').val(), $(this).val());
    });

    loadSavedSupplierVisitPlan($('#cmbOfficer').val(), $('#cmbYear').val(), $('#cmbMonth').val());




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var officer_id = param[0].split('=')[1].split('&')[0];
        var site = param[0].split('=')[2].split('&')[0];
        var product_id = param[0].split('=')[3].split('&')[0];
        var year = param[0].split('=')[4].split('&')[0];
        var month = param[0].split('=')[5].split('&')[0];
        ACTION = param[0].split('=')[6].split('&')[0];

        //mainRawMaterials();
        setSelectedOption('cmbOfficer', officer_id);
        //setSelectedOption('cmbItem', product_id);
        //setSelectedOption('cmbSite', site);
        setSelectedOption('cmbYear', year);
        setSelectedOption('cmbMonth', month);

        if (ACTION == 'edit') {

        } else if (ACTION == 'view') {
            $('#btnAction').hide();
        }



    }


    $('#btnAction').on('click', function () {

        if ($(this).text() == 'Save') {
            save();
        }
    });

    supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });
    var supplier_data = allSuppliers();
    //console.log(product_data);
    supplierChooser.setDataSource(supplier_data);


    supplierChooser.on('select', function (event, data) {
        var input = supplierChooser.getInput();
        input.focus();

        var supplier_id = data[0];
        var supplier_name = data[1];
        input.attr("data-id", supplier_id);
        input.val(supplier_name);

    });


    //addRow(0);



});







function fieldOfficers() {
    $.ajax({
        type: 'GET',
        url: '/fo/SupplierVisitPlanController/fieldOfficers',
        async: false,
        success: function (response) {
            console.log(response.data.result);
            $('#cmbOfficer').empty();
            if (response.data.success) {

                var html = '';
                $.each(response.data.result, function (index, value) {
                    html += '<option value="' + value.employee_id + '">' + value.name_withinitial + '</option>';
                })
                $('#cmbOfficer').html(html);
            }
        },
        error: function (data) {

        },
        complete: function () {

        }
    });
}




function save() {


    $.ajax({
        type: "POST",
        url: '/fo/SupplierVisitPlanController/save',
        data: {
            'data': dataSource(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Saved data.');
                $('#tblProductEmployeeDailyBody').empty();
                addRow(0);
                if (ACTION == 'edit') {
                    location.href = "/fo/plan_product_employee_daily_list";
                } else {
                    location.href = "/fo/supplier_visit_plan";
                }
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}




function addRow(id) {
    $('#' + id).text("Remove");
    $('#' + id).attr('class', 'btn btn-danger remove');
    $('#' + id).attr('onclick', '');

    var btn_id = "btnSave" + guidGenerator();
    var txtSupplier_id = "txtSuppier" + guidGenerator();
    var txtVisit_id = "txtVisit" + guidGenerator();
    var txtDate_id = "txtDate" + guidGenerator();



    var string_id = "'" + btn_id + "'";
    var string_txtSupplier_id = "'" + txtSupplier_id + "'";


    var text = document.createElement("INPUT");
    text.setAttribute("class", "form-control auto-complete");
    text.setAttribute("type", "text");
    text.setAttribute("id", txtSupplier_id);
    text.setAttribute("data-id", null);
    text.setAttribute("oninput", "showSupplierChooser(" + string_txtSupplier_id + ")");

    var row = '<tr id="' + id + '"><td id="td' + id + '"></td>';
    row += '<td><input id="' + txtDate_id + '" type="text" class="form-control-sm" style="width:150px; border:1px solid gray;background:white;" autocomplete="off" name="dteDate"></td>';
    row += '<td><input id="' + txtVisit_id + '" type="text" class="form-control-sm" style="width:300px; border:1px solid gray;text-align:right;" ></td>';
    row += '<td><button type="button" id="' + btn_id + '" class="btn btn-primary" onclick="addRow(' + string_id + ')">Add</button></td></tr>';
    $('#tblProductEmployeeDailyBody').append(row);


    $(".remove").click(function () {
        $(this).closest("tr").remove();
    });

    $("#td" + id).append(text);

    $('input[name="dteDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }
    });

    var comp = {
        "btn_id": btn_id,
        "supplier": $('#' + txtSupplier_id),
        "visit_detail": $('#' + txtVisit_id),
        "date": $('#' + txtDate_id),

    };

    return comp;

}


function guidGenerator() {
    var S4 = function () {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    return (S4() + S4());
}



function allSuppliers() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/fo/SupplierVisitPlanController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}





function dataSource() {

    var collection = {};
    var table = document.getElementById('tblProductEmployeeDailyBody'),
        rows = table.getElementsByTagName('tr'),
        i, j, cells, customerId;



    for (i = 0, j = rows.length; i < j; ++i) {
        var plan_product_id = rows[i].id;
        cells = rows[i].getElementsByTagName('td');
        if (!cells.length) {
            continue;
        }



        var data = {
            "employee_id": $('#cmbOfficer').val(),
            "year": $('#cmbYear').val(),
            "month": $('#cmbMonth').val(),
            "supplier_id": $('#' + cells[0].childNodes[0].id).attr('data-id'),
            "date": cells[1].childNodes[0].value,
            "visit_detail": cells[2].childNodes[0].value,
        };
        collection[i] = JSON.stringify(data);



    }

    return collection;

};


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function showSupplierChooser(id) {
    supplierChooser.showChooser($('#' + id));
}




function loadSavedSupplierVisitPlan(officer_id, year, month) {
    $.ajax({
        type: "GET",
        url: "/fo/SupplierVisitPlanController/loadSavedSupplierVisitPlan/" + officer_id + "/" + year + "/" + month,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var result = response.data.result;
            $('#tblProductEmployeeDailyBody').empty();
            addRow(0);
            if (result.length > 0) {


                setSelectedOption('cmbOfficer', result[0].employee_id);
                setSelectedOption('cmbYear', result[0].year);
                setSelectedOption('cmbMonth', result[0].month);



                $('#tblProductEmployeeDailyBody').empty();
                var childarray = { "btn_id": 0 };
                for (var i = 0; i < result.length; i++) {

                    childarray = addRow(childarray.btn_id);
                    childarray.date.val(result[i].visit_date);
                    childarray.visit_detail.val(result[i].visit_detail);
                    childarray.supplier.attr('data-id', result[i].supplier_id);
                    childarray.supplier.val(result[i].supplier_name);

                }
                addRow(childarray.btn_id);

            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}








/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
