@extends('fo::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">

<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Main Plan</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <label>Site</label>
                        <select class="form-control" id="cmbSite"></select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label>Year</label>
                        <select class="form-control" id="cmbYear"></select>
                    </div>
                    <div class="col-md-2 mb-3">
                        <label>Month</label>
                        <select class="form-control" id="cmbMonth">
                            <option value="1">January</option>
                            <option value="2">February</option>
                            <option value="3">March</option>
                            <option value="4">April</option>
                            <option value="5">May</option>
                            <option value="6">June</option>
                            <option value="7">July</option>
                            <option value="8">August</option>
                            <option value="9">September</option>
                            <option value="10">October</option>
                            <option value="11">November</option>
                            <option value="12">December</option>
                        </select>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table class="table table-sm" id="table_main_plan">
                                <thead>
                                    <tr>
                                        <th>Main Raw Material</th>
                                        <th style="max-width: 60px;">Quantity</th>
                                        <th style="max-width: 60px;">Stock INH</th>
                                        <th style="max-width: 60px;">Production<br>Requerment</th>
                                        <th style="max-width: 60px;">ReOrder Level</th>
                                        <th style="max-width: 60px;">Broaght Forward</th>
                                        <th style="max-width: 60px;">Requirment</th>
                                        <th style="max-width: 60px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="table_main_plan_body"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 mb-3" style="text-align: right;">
                        <button type="button" id="btnSavePlanProduct" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </div>

        </div>
    </div>



    <!--HR Modal -->

    <div class="modal fade" id="planModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-gl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Main Plan</h5>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <!-- Required for Responsive -->
                                <table class="table table-sm" id="table_plan_product_employee">
                                    <thead>
                                        <tr>
                                            <th>Field officer</th>
                                            <th style="max-width: 60px;">Quantity</th>
                                        </tr>
                                    </thead>
                                    <tbody id="table_plan_product_employee_body"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">

                    <button type="button" id="btnSavePlanProductFieldOfficer" class="btn btn-primary">Save</button>
                    <button type="button" name="canceladdorder" id="btnCancelAddOrder" class="btn btn-warning" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>


    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('fo:js/svr.js') }}"></script>
    <script src="{{ Module::asset('fo:js/fo_plan_product.js') }}?random=<?php echo uniqid(); ?>"></script>

    @endsection