@extends('fo::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('assets/js/autocomplete/css/autocomplete.min.css') }}">

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link href="{{ asset('assets/css/hr/settings.css') }}" media="all" rel="stylesheet" type="text/css" />
<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<!-- <div class="page-header">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div> -->

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Material Assign To Supplier</h6>
                <div class="row">
                    <!--Left side -->
                    <div class="col-md-12">
                        <div class="row">
                            <!-- <div class="col-md-12 mb-3">
                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                            <label for="txtSupplyDate">Date</label>
                            <input type="text" class="form-control" id="txtSupplyDate" name="txtSupplyDate">
                            <div class="valid-feedback">
                                Looks good!
                            </div>

                        </div> -->
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                <label>Supplier</label>
                                <input type="hidden" id="hidSupplierID" name="hidSupplierID" value="">
                                <input type="text" class="form-control auto-complete" id="txtSupplier" name="txtSupplier" placeholder="Supplier" required="" autocomplete="off">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-12">
                                <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                                <label>Address</label>
                                <textarea class="form-control" id="txtEmployeeAddress" name="txtEmployeeAddress" placeholder="Address"></textarea>
                            </div>
                        </div>

                        <br><br>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <!-- Required for Responsive -->
                                    <table id="example1" class="table table-bordered" name="example1">
                                        <!-- productTable -->
                                        <thead class="table-active">
                                            <tr>
                                                <th>Product ID</th>
                                                <th>Product Name</th>
                                                <th>Select</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbodySupply">
                                        </tbody>

                                    </table>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <!-- Required for Responsive -->
                                    <!-- <form action="" name="myTable" > -->
                                    <table id="example3" class="table table-bordered" name="ProductAssignTable" ondrop="drop(event)" ondragover="allowDrop(event)">

                                        <thead class="table-active">
                                            <tr>
                                                <th>ProductID</th>
                                                <th>Product Name</th>
                                                <th>Status</th>
                                                <th>Delete</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbodySupplyAssigned">
                                        </tbody>

                                    </table>
                                    <!-- </form> -->
                                </div>
                            </div>



                        </div>



                        <hr>

                        <div class="row">
                            <div class="col-md-12">
                                <br>
                                <button type="button" class="btn btn-primary" id="btnAddToList" onclick="GetSelected()">Add To List</button>
                            </div>
                        </div>

                    </div>



                </div>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body" id="attachmentAddModalBody">
                <div class="row">
                    <div class="col-md-12">
                        <form action="{{route('upload')}}" class="dropzone" method="POST" id="myAwesomeDropzone" name="myAwesomeDropzone">
                            @csrf
                            <input type="hidden" id="employee_id" name="employee_id" value="">
                            <div class="fallback">
                                <input name="file" type="file" multiple />
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                    </button>
                    <button type="button" class="btn btn-primary" id="btnSetting" onclick="save()">Save</button>
                </div>
            </div>
        </div>
    </div>
    <!-- autocomplete  -->
    <script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>


    <!-- jquery ui library  -->
    <script src="{{ url('assets/js/ui/jquery-ui.min.js') }}"></script>

    <script>
        var supplier_datas = LoadSuppliers();

        console.log(supplier_datas);


        $('#txtSupplier').setData(supplier_datas);


        function autoCompleteSelectedOption(input, data) {

            if (input.id == "txtSupplier") {
                var id = data.id;
                console.log(id);
                $('#hidSupplierID').val(id);
                GetSupplierAddress(id);
            }
        }

        // This function is use to get supplier address
        function GetSupplierAddress(id) {
            //console.log(id);
            //var product_ids = [];
            $.ajax({
                type: 'GET',
                url: '/fo/supplierMaterials/GetSupplierAddress/' + id,
                success: function(response) {
                    console.log(response);

                    // response.data.result.assignedProducts.forEach(function(element) {
                    //     product_ids.push({"productId": element['product_Id']});
                    // });

                    var address = response.data.result['address'][0]['address'];
                    //var product_id = response.data.result['assignedProducts'][0]['product_Id'];
                    //console.log(product_id);

                    //console.log(product_ids);

                    if (response.data.success) {
                        //LoadAssignedProducts(product_ids);
                        $('#txtEmployeeAddress').text(address);
                        var html = '';
                        $.each(response.data.result.assignedProducts, function(index, value) {
                            html += '<tr>';
                            html += '<td id="' + value.product_primary_id + '">' + value.product_id + '</td>';
                            html += '<td id="product_id">' + value.product_name + '</td>';
                            html += '<td>';
                            html += '<div class="custom-control custom-switch custom-checkbox-primary">';
                            html += '<input type="checkbox" class="custom-control-input" id="slideAlert" checked>';
                            html += '<label class="custom-control-label" for="slideAlert"></label>';
                            html += '</div>';
                            html += '</td>';
                            html += '<td class="disable">';
                            html += '<i class="fa fa-trash text-danger fa-1x"  role="button" onclick="_delete(' + value.supplier_materials_id + ')"></i>';
                            html += '</td>';
                            html += '</tr>';
                        });
                        $('#tbodySupplyAssigned').html(html);
                    }



                },
                error: function(data) {
                    console.log('something went wrong!');
                }
            });
        }

        // Drag and drop function set
        function allowDrop(evt) {
            evt.preventDefault();
        }

        function drop(evt) {
            evt.preventDefault();
            var supplier_id = $('#hidSupplierID').val();
            var data = evt.dataTransfer.getData("text");
            console.log(data);
            var validate = validation(data);
            console.log(validate);
            if (validate == false) {
                //console.log('existing record!');
                $.ajax({
                    type: 'POST',
                    url: '/fo/supplierMaterials/assignProducts',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "data": data,
                        "supplier_id": supplier_id,
                    },
                    success: function(response) {
                        console.log(response);
                        //autoCompleteSelectedOption();
                        if (response.data.success) {
                            toastr.success('Record Assigned To Supplier!');
                            var supplier_id = response.data.result;
                            //console.log(supplier_id);
                            GetAssignedData(supplier_id);
                        } else {
                            toastr.error('something went wrong!');
                        }
                    },
                    error: function(data) {
                        console.log('something went wrong!');
                    }
                });
            } else {
                toastr.error('Unable to assign..!');
            }

        }


        function GetAssignedData(supplier_id) {
            var id = supplier_id;
            //console.log(id);
            $.ajax({
                type: 'GET',
                url: '/fo/supplierMaterials/GetAssignProducts/' + id,
                success: function(response) {
                    console.log(response);

                    if (response.data.success) {
                        var html = '';
                        $.each(response.data.result, function(index, value) {
                            html += '<tr>';
                            html += '<td id="' + value.product_primary_id + '">' + value.product_id + '</td>';
                            html += '<td id="product_id">' + value.product_name + '</td>';
                            html += '<td>';
                            html += '<div class="custom-control custom-switch custom-checkbox-primary">';
                            html += '<input type="checkbox" class="custom-control-input" id="slideAlert" checked>';
                            html += '<label class="custom-control-label" for="slideAlert"></label>';
                            html += '</div>';
                            html += '</td>';
                            html += '<td class="disable">';
                            html += '<i class="fa fa-trash text-danger fa-1x"  role="button" onclick="_delete(' + value.supplier_materials_id + ')"></i>';
                            html += '</td>';
                            html += '</tr>';
                        });
                        $('#tbodySupplyAssigned').html(html);
                    }


                },
                error: function(data) {
                    console.log('something went wrong');
                }
            });
        }

        //validation function
        function validation(data) {
            var product_id = data;
            var message = "";
            var values = [];

            console.log(product_id);

            $('#tbodySupplyAssigned tr').each(function(index, value) {
                var value1 = $(value).children().eq(0).text();
                var value2 = $(value).children().eq(1).text();
                console.log(value1);
                //console.log(value2);
                if (value1 == product_id) {
                    message = true;
                    alert('Record Alredy Existing..!');
                } else {
                    message = false;
                }
            });
            console.log(message);
            return message;
        }

        // delete assign products
        function _delete(id) {
            var id = id;
            console.log(id);
            $.ajax({
                type: 'DELETE',
                url: '/fo/supplierMaterials/DeleteAssignProducts/' + id,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                },
                success: function(response) {
                    console.log(response);
                    var supplier_id = $('#hidSupplierID').val();
                    LoadCheckedData(supplier_id);
                }
            });
        }



        // Inactive funtion here
        // This function is use to load assigned data to the supplier
        function LoadAssignedProducts(product_ids) {
            //console.log(product_id);
            $.ajax({
                type: 'GET',
                url: '/fo/supplierMaterials/GetSupplierAssignedProducts/' + product_ids,
                success: function(response) {
                    console.log(response);
                    var html = '<tr>';
                    $.each(response.data.result, function(index, value) {
                        html += '<td id="' + value.product_primary_id + '">' + value.product_id + '</td>';
                        html += '<td>' + value.product_name + '<td>';
                        html += '<td>';
                        html += '<div class="custom-control custom-switch custom-checkbox-primary">';
                        html += '<input type="checkbox" class="custom-control-input" id="slideAlert" checked>';
                        html += '<label class="custom-control-label" for="slideAlert"></label>';
                        html += '</div>';
                        html += '</td>';
                        html += '<td><i class="fa fa-trash text-danger fa-1x"  role="button"></i></td>'
                        html += '</tr>';
                    });
                    $('#tbodySupplyAssigned').html(html);
                },
                error: function(data) {
                    console.log('Something went wrong!');
                }
            });
        }


        function LoadSuppliers() {
            var supplier_data = [];
            $.ajax({
                type: 'GET',
                url: '/fo/supplierMaterials/getSupplier',
                success: function(response) {

                    response.data.result.forEach(function(element) {
                        supplier_data.push({
                            "img": "",
                            "id": element['supplier_id'],
                            "value": element['supplier_name']
                        });
                    });

                    // var supplier_data = response.data.result.map((array) => ({ img: array.address, id: array.supplier_id, value: array.supplier_name }));
                    // var supplier_data = response.data.result.map(function (array) { return {img: array.address, id: array.supplier_id, value: array.supplier_name}; });

                },
                error: function(data) {
                    console.log('something went wrong!');
                }
            });
            return supplier_data;
        }
    </script>
    @endsection

    <!-- Javascript -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/js/examples/datatable.js') }}"></script>

    <!-- Javascript -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- <script src="{{ url('assets/js/hr/supplier_material.js') }}"></script> -->

    <!-- Module JS -->
    <script src="{{ Module::asset('fo:js/fo/supplier_material.js') }}"></script>


    @endsection