@extends('fo::layouts.app')

@section('head')

<meta charset="ISO-8859-1">

<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.css') }}" type="text/css">

<!-- Fullcalendar -->
<link rel="stylesheet" href="{{ url('vendors/fullcalendar/fullcalendar.min.css') }}" type="text/css">

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<!-- Map JS  -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-ui-map/3.0-rc1/jquery.ui.map.js"></script>
<!-- <script src="https://maps.googleapis.com/maps/api/js"></script> -->


<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<link href="{{ asset('assets/css/hr/settings.css') }}" media="all" rel="stylesheet" type="text/css" />


<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('fo:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">
<script>
    var uid = "{{Auth::user()->user_id}}";
</script>
@endsection

@section('content')

<!-- <div class="page-header">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div> -->

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Supplier Visit</h6>
                <div class="row">
                    <div class="col-md-7">
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer ID</label>
                                <input type="hidden" value="1" id="hidEmployeeID" name="hidEmployeeID">
                                <input type="text" class="form-control auto-complete" id="FieldOfficer_combo" autocomplete="off">
                            </div>
                            <div class="col-md-8 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Field Officer</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp2" autocomplete="off">
                            </div>
                        </div>

                        <div class="row">
                            <!-- <div class="col-md-4 mb-3">
                                <i class="fa fa-search text-info" aria-hidden="true"></i>
                                <label>Date</label>
                                <input type="text" class="form-control" name="date" id="txtDate" placeholder="YYYY-MM-DD">
                            </div> -->
                            <div class="col-md-8 mb-3">
                                <div id="dashboard-daterangepicker" class="btn btn-outline-light">
                                    <span>Jan, 05, 2021</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="imgContainer">
                                    <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <!-- <div class="col-md-5">
                        <div>
                            <button type="button" id="btnGrp1modal" class="btn btn-primary" data-target="#supplierAssignModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save', 'supplier')">
                                <i class="fa fa-plus" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div> -->
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <ul class="nav nav-pills mb-3" role="tablist" id="navMenuItem">
                            <li class="nav-item">
                                <a class="nav-link active" id="pills-general-tab" data-toggle="pill" href="#tbGeneral" role="tab" aria-controls="pills-general" aria-selected="true">Visit List</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#tbContactInfo" role="tab" aria-controls="pills-contact" aria-selected="false">Calander</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#tbMap" role="tab" aria-controls="pills-contact" aria-selected="false">Map</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="tbGeneral" role="tabpanel" aria-labelledby="pills-general-tab">
                                <div class="row">
                                    <div class="col-md-12 seperator">
                                        <div class="card bg-primary">
                                            <div class="card-header">Visit List</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-5">
                                        <div>
                                            <button type="button" id="btnGrp1modal" class="btn btn-primary" data-target="#supplierAssignModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save', 'supplierVisit', null)">
                                                <i class="fa fa-plus" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <table id="tblSupplierPlan" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th>Supplier Name</th>
                                                    <th>Arrived On</th>
                                                    <th>Depatured On</th>
                                                    <th>Observation</th>
                                                    <th>Edit</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody"></tbody>
                                        </table>
                                    </div>
                                </div>



                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <hr>
                                    </div>
                                </div>




                                <!-- <div class="row">
                                    <div class="col-md-12 seperator">
                                        <div class="card bg-primary">
                                            <div class="card-header">Employee List</div>
                                        </div>
                                    </div>
                                </div> -->


                                <!-- <div class="row">
                                    <div class="col-md-12">
                                        <table id="tblEmployeeSupervisor" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th class="id">Employee ID</th>
                                                    <th>Name</th>
                                                    <th>Category</th>
                                                    <th>Site</th>
                                                    <th>Department</th>
                                                    <th>Section</th>
                                                    <th>Subsection</th>
                                                    <th>Set</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tbody"></tbody>
                                        </table>
                                    </div>
                                </div> -->
                            </div>
                            <div class="tab-pane fade" id="tbContactInfo" role="tabpanel" aria-labelledby="pills-contact-tab">
                                <div class="card ">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-12 app-content">
                                                <div class="row">
                                                    <div class="col-md-12 seperator">
                                                        <div class="card bg-primary">
                                                            <div class="card-header">Calander</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="app-content-overlay"></div>
                                                <div class="card app-content-body">
                                                    <div class="card-body">
                                                        <!--<a href="#" class="app-sidebar-menu-button btn btn-outline-light mb-3">
                                                            <i data-feather="menu"></i>
                                                        </a>!-->
                                                        <!-- <div class="row">
                                                            <div class="col-md-12" style="text-align: right;">
                                                                <div id="dashboard-daterangepicker" class="btn btn-outline-light">
                                                                    <span>Jan, 05, 2021</span>
                                                                </div>
                                                            </div>
                                                        </div> -->
                                                        <br>
                                                        <div id="calendar-demo"></div>
                                                    </div>
                                                </div>
                                            </div>



                                            <!-- begin::Event Info Modal -->
                                            <div class="modal fade" id="viewEventModal" tabindex="-1" role="dialog" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">
                                                                <span class="event-icon mr-2"></span>
                                                                <span class="event-title">Modal Title</span>
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <i class="ti-close"></i>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="event-body"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end::Event Info Modal -->
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="tbMap" role="tabpanel" aria-labelledby="pills-contact-tab">
                                <div class="card ">
                                    <div class="card-body">
                                        <div class="row justify-content-center">
                                            <div class="col-md-6 app-content" id="googleMap" style="width:100%;height:450px;">
                                                <input type="hidden" name="hidLatt" id="hidLatt" value="6.901608599999999">
                                                <input type="hidden" name="hidLong" id="hidLong" value="80.0087746">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Supplier visit Modal  -->
    <div class="modal fade" id="supplierAssignModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsAddModalTitle">Add supplier Visit</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form method="POST" id="myForm">
                    {{csrf_field()}}
                    <input type="hidden" id="supplierID" name="supplierID" value>
                    <div class="modal-body" id="settingsAddModalBody">
                        <div class="form-row">
                            <div class="col-md-12 mb-3" id="divSection">
                                <input type="hidden" id="hidSupplierId" name="hidSupplierId">
                                <input type="hidden" id="hidSupVisitId" name="hidSupVisitId">
                                <label for="txtName" id="lblSupplierName">Supplier Name</label>
                                <!-- onchange="SupplierAddressBySupplierID()" -->
                                <select class="form-control" id="selectSupplierName" name="selectSupplierName"></select>
                            </div>
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="supplier">Arrived On</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" id="arrivedOn" name="arrivedOn" disabled>
                                    </div>
                                    <div class="col-md-1"></div>
                                    <div class="col-md-3">
                                        <button type="button" class="btn btn-sm btn-info" id="btnArrivedOn">Arrived</button>
                                    </div>
                                </div>
                                <div class="row" id="divDepature">
                                    <div class="col-md-4">
                                        <label for="supplier">Depatured On</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" id="DepaturedOn" name="DepaturedOn" disabled>
                                    </div>
                                    <div class="col-md-1"></div>
                                    <div class="col-md-3">
                                        <button type="button" class="btn btn-sm btn-info" id="btnDepaturedOn">Depatured</button>
                                    </div>
                                </div>
                                <div class="row" id="divObservation">
                                    <div class="col-md-3">
                                        <label for="observation">Observations</label>
                                    </div>
                                    <br>
                                    <div class="col-md-9">
                                        <textarea class="form-control" id="txtObservation" name="txtObservation" placeholder="Observations"></textarea>
                                    </div>
                                </div>
                                <div class="row" id="divLocation">
                                    <div class="col-md-4">
                                        <input type="hidden" name="hidLatitude" id="hidLatitude">
                                        <input type="hidden" name="hidLongitude" id="hidLongitude">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnAssignSupplier">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <!-- jquery ui library  -->
    <script src="{{ url('assets/js/ui/jquery-ui.min.js') }}"></script>


    <script>
        var map;

        function initMap(arr) {
            // map = new google.maps.Map(document.getElementById('googleMap'), {
            //   center: {lat: 7.8731, lng: 80.7718},
            //   zoom: 8

            const mapOptions = {
                zoom: 7.3,
                center: {
                    lat: 7.8728,
                    lng: 80.7718
                },
            };
            map = new google.maps.Map(document.getElementById("googleMap"), mapOptions);
            // var lattitude = $('#hidLatt').val();
            // var longitude = $('#hidLong').val();

            //wrote by nipuna start
            for (i = 0; i < arr.length; i++) {
                var latt = arr[i]['latitude'];
                var long = arr[i]['longitude'];
                var marker = new google.maps.Marker({

                    position: {
                        lat: parseFloat(latt),
                        lng: parseFloat(long)
                    },
                    map: map,

                });


                const infowindow = new google.maps.InfoWindow({
                    content: "<p>Marker Location:" + marker.getPosition() + "</p>",
                });
                google.maps.event.addListener(marker, "click", () => {
                    infowindow.open(map, marker);
                });
            }
            //nipuna end

            // var marker = new google.maps.Marker({
            // The below line is equivalent to writing:
            // // position: new google.maps.LatLng(-34.397, 150.644)
            //         position: { lat: parseFloat(latt), lng: parseFloat(long) },
            //         map: map,

            //     });
            // You can use a LatLng literal in place of a google.maps.LatLng object when
            // creating the Marker object. Once the Marker object is instantiated, its
            // position will be available as a google.maps.LatLng object. In this case,
            // we retrieve the marker's position using the
            // google.maps.LatLng.getPosition() method.

            // const infowindow = new google.maps.InfoWindow({
            // content: "<p>Marker Location:" + marker.getPosition() + "</p>",
            // });
            // google.maps.event.addListener(marker, "click", () => {
            // infowindow.open(map, marker);
            // });

        }
        // });
        // });
        //   }
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyADEs_HbO-HGfiZPqmV5t5CuXYgokQUhyU&callback=initMap" async defer></script>
    @endsection

    <!-- Javascript -->
    <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> -->
    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('assets/js/examples/datatable.js') }}"></script>



    <!-- Fullcalendar -->
    <script src="{{ url('vendors/fullcalendar/moment.min.js') }}"></script>
    <script src="{{ url('vendors/fullcalendar/fullcalendar.min.js') }}"></script>

    <!-- Javascript -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- <script src="{{ url('assets/js/hr/supplier_material.js') }}"></script> -->

    <!-- AutoComplete -->
    <script src="{{ Module::asset('fo:js/autocomplete2/js/autocomplete.min.js') }}"></script>

    <!-- Module JS -->
    <script src="{{ Module::asset('fo:js/fo/supplier_visit.js') }}"></script>

    <!-- calender lib  -->
    <script src="{{ Module::asset('fo:js/fo/calanderVist.js') }}"></script>


    <!-- Prism -->
    <script src="{{ url('vendors/prism/prism.js') }}"></script>


    @endsection