@extends('fo::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">

<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Supplier Visit Plan</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title">Supplier visit Plan</h6>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <label>Officer's Name</label>
                        <select id="cmbOfficer" class="form-control"></select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-5 mb-3">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label>Year</label>
                                <select class="form-control" id="cmbYear"></select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label>Month</label>
                                <select class="form-control" id="cmbMonth">
                                    <option value="1">January</option>
                                    <option value="2">February</option>
                                    <option value="3">March</option>
                                    <option value="4">April</option>
                                    <option value="5">May</option>
                                    <option value="6">June</option>
                                    <option value="7">July</option>
                                    <option value="8">August</option>
                                    <option value="9">September</option>
                                    <option value="10">October</option>
                                    <option value="11">November</option>
                                    <option value="12">December</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-10">txtOfficerQuantity
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table class="table table-sm table-striped">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Supplier</th>
                                        <th>Name</th>
                                        <th>Area</th>
                                        <th>Visit Details</th>
                                        <th>Remark</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="tblProductEmployeeDailyBody">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!--<div class="row">
                    <div class="col-md-5 mb-3">
                        <label>Supplier</label>
                        <select id="cmbSupplier" class="form-control"></select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-5 mb-3">
                        <label>Quantity</label>
                        <input type="text" id="txtQuantity" class="form-control">
                    </div>
                </div>!-->
                <hr>
                <div class="row">
                    <div class="col-md-8 mb-3">
                        <button type="button" id="btnAction" class="btn btn-primary">Save</button>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <div id="supplierChooser"></div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('fo:js/svr.js') }}"></script>
    <script src="{{ Module::asset('fo:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('fo:js/supplier_visit_plan.js') }}?random=<?php echo uniqid(); ?>"></script>

    @endsection