<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalaryDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_salary_data', function (Blueprint $table) {
            $table->id();
            $table->string("employee_id",25);
            $table->integer('category_id');
            $table->integer('site_id');
            $table->integer('department_id');
            $table->integer('section_id');
            $table->integer('subsection_id');
            $table->integer('company_id');
            $table->double('basic_salary');

            $table->double('ot_hours1');
            $table->double('ot_rate1');
            $table->double('ot_rate1_amount');
            $table->double('ot_amount1');
            $table->double('ot_hours2');
            $table->double('ot_rate2');
            $table->double('ot_rate2_amount');
            $table->double('ot_amount2');
            $table->double('ot_hours3');
            $table->double('ot_rate3');
            $table->double('ot_rate3_amount');
            $table->double('ot_amount3');

            $table->double('advance');
            $table->double('loan');
            $table->double('loan_interest');
            $table->double('debtor_loan');
            $table->double('debtor_loan_interest');
            $table->double('worked_days');

            $table->double('nopay_days');
            $table->double('nopay_amount');
            $table->double('budget1');
            $table->double('budget2');
            $table->double('employer_epf');
            $table->double('employee_epf');
            $table->double('employee_etf');
            $table->double('tax1');
            $table->double('tax2');
            $table->double('fine_hours');
            $table->double('fine_amount');

            $table->integer('earn_trans_id_01');
            $table->double('earn_01');
            $table->integer('earn_trans_id_02');
            $table->double('earn_02');
            $table->integer('earn_trans_id_03');
            $table->double('earn_03');
            $table->integer('earn_trans_id_04');
            $table->double('earn_04');
            $table->integer('earn_trans_id_05');
            $table->double('earn_05');
            $table->integer('earn_trans_id_06');
            $table->double('earn_06');
            $table->integer('earn_trans_id_07');
            $table->double('earn_07');
            $table->integer('earn_trans_id_08');
            $table->double('earn_08');
            $table->integer('earn_trans_id_09');
            $table->double('earn_09');
            $table->integer('earn_trans_id_10');
            $table->double('earn_10');
            
            $table->integer('deduct_trans_id_01');
            $table->double('deduct_01');
            $table->integer('deduct_trans_id_02');
            $table->double('deduct_02');
            $table->integer('deduct_trans_id_03');
            $table->double('deduct_03');
            $table->integer('deduct_trans_id_04');
            $table->double('deduct_04');
            $table->integer('deduct_trans_id_05');
            $table->double('deduct_05');
            $table->integer('deduct_trans_id_06');
            $table->double('deduct_06');
            $table->integer('deduct_trans_id_07');
            $table->double('deduct_07');
            $table->integer('deduct_trans_id_08');
            $table->double('deduct_08');
            $table->integer('deduct_trans_id_09');
            $table->double('deduct_09');
            $table->integer('deduct_trans_id_10');
            $table->double('deduct_10');

            $table->decimal('last_adjustment');
            $table->decimal('this_adjustment');
            $table->double('gross_salary');
            $table->double('total_deduction');
            $table->double('net_salary');
            $table->float('salary_month');
            $table->float('salary_year');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salary_data');
    }
}
