<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRecruitmentRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_recruitment_requests', function (Blueprint $table) {
            $table->id('recruitment_id',25)->unique();
            $table->foreignId('department_id');
            $table->foreignId('designation_id'); 
            $table->string('job_role',200);
            $table->integer('no_of_vacant');
            $table->date('post_date');
            $table->date('expire_date');
            $table->integer('age_from');
            $table->integer('age_to');
            $table->string('education_qualification',300);
            $table->string('experience',300);
            $table->string('remarks',300);
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recruitment_requests');
    }
}
