<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeSection extends Model
{
    protected $table = 'hr_employee_sections';
    protected $primaryKey = 'section_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'section_id',
        'section',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_employee_sections";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
