<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class MohDivision extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'hr_moh_divisions';
    protected $primaryKey = 'moh_division_id';

    protected $fillable = [];
    protected static $logAttributes = [
        'moh_division_id',
        'moh_division',
        'moh_mobile',
        'office_phone',
        'contact_person',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_moh_divisions";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Hr\Database\factories\MohDivisionFactory::new();
    }*/
}
