<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class Recruitment extends Model
{
    protected $table = 'hr_recruitment_requests';
    protected $primaryKey = 'recruitment_id';
    public $incrementing = false;
    protected $keyType = 'string';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'recruitment_id',
        'department_id',
        'designation_id',
        'job_role',
        'no_of_vacant',
        'post_date',
        'expire_date',
        'age_from',
        'age_to',
        'education_qualification',
        'experience',
        'remarks',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_recruitment_requests";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
