<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class AttendanceRawDataReportController extends Controller
{

    public function getReportRawData($setting, $fromdate,$todate)
    {

        try {

            $title = 'Rawdata Report';
            $setting_aaray =  json_decode($setting);
            $category = $setting_aaray->category;
            $site = $setting_aaray->site;
            $department = $setting_aaray->department;
            $section = $setting_aaray->section;
            $subsection = $setting_aaray->subsection;
            $company = $setting_aaray->company;
            $team = $setting_aaray->team;
            $employee = $setting_aaray->employee;

            $query = "SELECT HARD.ID,
            HE.name_withinitial AS name,
            DATE(HARD.ImportDate) AS date,
            TIME(HARD.ChecKINOUT) AS time
            FROM hr_att_raw_data HARD
            INNER JOIN hr_employees HE ON HARD.ID = HE.employee_id
            WHERE ";


            if ($category != '') {
                $query .= "HE.category_id = '" . $category . "' AND ";
            }

            if ($site != '') {
                $query .= "HE.site_id = '" . $site . "' AND ";
            }

            if ($department != '') {
                $query .= "HE.department_id = '" . $department . "' AND ";
            }

            if ($section != '') {
                $query .= "HE.section_id = '" . $section . "' AND ";
            }

            if ($subsection != '') {
                $query .= "HE.subsection_id = '" . $subsection . "' AND ";
            }

            if ($company != '') {
                $query .= "HE.company_id = '" . $company . "' AND ";
            }

            if ($team != '') {
                $query .= "HE.team_id = '" . $team . "' AND ";
            }

            if ($employee != '') {
                $query .= "HE.employee_id = '" . $employee . "' AND ";
            }

            $query .= "DATE(HARD.ImportDate) BETWEEN '" . $fromdate . "' AND '".$todate."' ORDER BY HARD.ID,DATE(HARD.ImportDate) ASC";


            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "Attendance", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name"    => $name,
            "result"  => $result,
        ];
        return $body;
    }
}
