<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeOtherEarningDeduction;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\EmployeeTeam;
use Modules\Hr\Entities\OtherEarningDeduction;
use Modules\Hr\Entities\Team;

class EmployeeOtherEarningDeductionController extends Controller
{
    //
    public function allSettings()
    {

        try {
            $settings = [
                "allowance" => $this->allowance(),
                "category" => $this->category(),
                "site" => $this->site(),
                "section" => $this->section(),
                "department" => $this->department(),
                "company" => $this->company(),
                "team" => $this->teams(),
                "employee" => $this->allEmployee(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allowance()
    {

        try {
            $allowance = OtherEarningDeduction::all();
            $collection = [];
            for ($i = 0; $i < count($allowance); $i++) {
                array_push($collection, ["id" => $allowance[$i]['earn_deduct_id'], "value" => $allowance[$i]['title']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    private function category()
    {

        try {
            $category = EmployeeCategory::all();
            $collection = [];
            for ($i = 0; $i < count($category); $i++) {
                array_push($collection, ["id" => $category[$i]['category_id'], "value" => $category[$i]['category']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    private function department()
    {

        try {
            $section = EmployeeDepartment::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['department_id'], "value" => $section[$i]['department']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function section()
    {

        try {
            $section = EmployeeSection::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['section_id'], "value" => $section[$i]['section']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function subSection($section_id)
    {
        try {
            $subsection = EmployeeSubsection::where('section_id', '=', $section_id)->get();
            $collection = [];
            for ($i = 0; $i < count($subsection); $i++) {
                array_push($collection, ["id" => $subsection[$i]['subsection_id'], "value" => $subsection[$i]['subsection']]);
            }
            $responseBody = $this->responseBody(true, "Subsection", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function company()
    {

        try {
            $section = Company::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['company_id'], "value" => $section[$i]['company']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    private function teams()
    {

        try {
            $teams = Team::all();
            $collection = [];
            for ($i = 0; $i < count($teams); $i++) {
                array_push($collection, ["id" => $teams[$i]['team_id'], "value" => $teams[$i]['team_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }







    private function allEmployee()
    {
        try {
            $employees = Employee::all();

            $collection = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($collection, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function applyCategory(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeCategory = $this->employeeCategory($id);

            if (count($employeeCategory) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeCategory); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeCategory[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeCategory[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "CategoryAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeCategory[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "CategoryAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CategoryAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function applySite(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeSite = $this->employeeSite($id);

            if (count($employeeSite) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeSite); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeSite[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeSite[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "siteAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeSite[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "siteAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "siteAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function applyDepartment(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeDepartment = $this->employeeDepartment($id);

            if (count($employeeDepartment) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeDepartment); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeDepartment[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeDepartment[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "departmentAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeDepartment[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "departmentAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "departmentAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function applySection(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeSection = $this->employeeSection($id);

            if (count($employeeSection) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeSection); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeSection[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeSection[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "sectionAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeSection[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "sectionAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "sectionAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function applySubsection(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeSubsection = $this->employeeSubsection($id);

            if (count($employeeSubsection) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeSubsection); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeSubsection[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeSubsection[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "subSectionAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeSubsection[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "subSectionAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "subSectionAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function applyCompany(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeCompany = $this->employeeCompany($id);

            if (count($employeeCompany) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeCompany); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeCompany[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeCompany[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "companyAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeCompany[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "companyAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "companyAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function applyTeam(Request $request, $allowance_id, $amount)
    {
        try {
            $id = $request->get('id');
            $employeeTeam = $this->employeeTeam($id);

            if (count($employeeTeam) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeTeam); $i++) {

                $isAllowance =  $this->isAssignedAllowance($employeeTeam[$i]->employee_id, $allowance_id);
                if (!$isAllowance) {
                    $status = $this->save($employeeTeam[$i]->employee_id, $allowance_id, $amount);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "teamAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                } else {
                    $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employeeTeam[$i]->employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                    if ($allowance) {
                        $allowance->amount = $amount;
                        $allowance->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "teamAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "teamAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function applyByEmployeeId(Request $request, $allowance_id, $amount)
    {

        try {
            $employee_id = $request->get('id');
            $isAllowance =  $this->isAssignedAllowance($employee_id, $allowance_id);
            if (!$isAllowance) {
                $status = $this->save($employee_id, $allowance_id, $amount);
                if (!$status['save']) {
                    $responseBody = $this->responseBody(false, "employeeAllowance", "error", $status['error']);
                    return response()->json(["data" => $responseBody]);
                }
            } else {
                $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employee_id)->where('earn_deduct_id', '=', $allowance_id)->first();
                if ($allowance) {
                    $allowance->amount = $amount;
                    $allowance->update();
                }
            }

            $responseBody = $this->responseBody(true, "employeeAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "employeeAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function isAssignedAllowance($employee, $allowance)
    {
        $isAllowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employee)->where('earn_deduct_id', '=', $allowance)->first();

        if ($isAllowance) {
            return true;
        }
        return false;
    }


    private function employeeCategory($id)
    {
        return Employee::where('category_id', '=', $id)->get();
    }


    private function employeeSite($id)
    {
        return Employee::where('site_id', '=', $id)->get();
    }



    private function employeeDepartment($id)
    {
        return Employee::where('department_id', '=', $id)->get();
    }


    private function employeeSection($id)
    {
        return Employee::where('section_id', '=', $id)->get();
    }



    private function employeeSubsection($id)
    {
        return Employee::where('subsection_id', '=', $id)->get();
    }


    private function employeeCompany($id)
    {
        return Employee::where('company_id', '=', $id)->get();
    }



    private function employeeTeam($id)
    {
        return EmployeeTeam::where('team_id', '=', $id)->get();
    }



    private function employee($id)
    {
        return Employee::where('employee_id', '=', $id)->get();
    }


    private function save($employee_id, $allowance_id, $amount)
    {
        try {
            $allowance = new EmployeeOtherEarningDeduction();
            $allowance->employee_id = $employee_id;
            $allowance->earn_deduct_id = $allowance_id;
            $allowance->amount = $amount;
            $allowance->save();
        } catch (\Exception $exception) {
            return ["save" => false, "error" => $exception];
        }
        return ["save" => true];
    }


    public function employeeAllowance(Request $request, $settings)
    {

        try {
            $settings_id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeBySettings($settings, $settings_id, $allowance_id);
            $responseBody = $this->responseBody(true, "EmployeeAllowance", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    private function employeeBySettings($settings, $settings_id, $allowance_id)
    {
        if ($settings == "category") {
            $column = "hr_employees.`category_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "site") {
            $column = "hr_employees.`site_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "department") {
            $column = "hr_employees.`department_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "section") {
            $column = "hr_employees.`section_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "subsection") {
            $column = "hr_employees.`subsection_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "company") {
            $column = "hr_employees.`company_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "team") {
            $column = "hr_employee_teams.`team_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        } else if ($settings == "employee") {
            $column = "hr_employees.`employee_id` = '" . $settings_id . "'AND hr_other_earning_deduction.`earn_deduct_id` = '" . $allowance_id . "'";
        }

        $query = "SELECT DISTINCT hr_employees.employee_id AS employees_employee_id,
        hr_employees.name_withinitial AS employees_name_withinitial,
        hr_other_earning_deduction.title AS other_earning_deduction_title,
        hr_employee_other_earning_deductions.earn_deduct_id AS earn_deduct_id,
        hr_employee_other_earning_deductions.amount
        FROM hr_employee_other_earning_deductions
        INNER JOIN hr_employees ON hr_employee_other_earning_deductions.employee_id = hr_employees.employee_id
        INNER JOIN hr_other_earning_deduction ON hr_employee_other_earning_deductions.earn_deduct_id = hr_other_earning_deduction.earn_deduct_id
        LEFT JOIN hr_employee_teams ON hr_employees.employee_id = hr_employee_teams.employee_id WHERE " . $column;
        return DB::select($query);
        //return $query;
    }



    public function denyCategory(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeCategory($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "CategoryAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CategoryAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function denySite(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeSite($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "SiteAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SiteAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function denyDepartment(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeDepartment($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "DepartmentAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "DepartmentAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function denySection(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeSection($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "SectionAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SectionAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function denySubsection(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeSubsection($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "SubsectionAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SubsectionAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function denyCompany(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeCompany($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "CompanyAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CompanyAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function denyTeam(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employeeTeam($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "TeamAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TeamAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function denyEmployee(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $allowance_id = $request->get('allowance_id');
            $employees = $this->employee($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $allowance_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "CompanyAllowance", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CompanyAllowance", "error", "sampath");
        }
        return response()->json(["data" => $responseBody]);
    }




    private function deny($employee_id, $allowance_id)
    {

        try {
            $allowance = EmployeeOtherEarningDeduction::where('employee_id', '=', $employee_id)->where('earn_deduct_id', '=', $allowance_id);
            $delete = $allowance->delete();
            //if ($delete) {
            return $this->responseBody(true, "Allowance", "deleted", null);
            //} else {
            //return $this->responseBody(false, "Allowance", "error", "not deleted");
            //}
        } catch (\Exception $exception) {
            return $this->responseBody(false, "Allowance", "error", $exception);
        }
    }



    public function deleteAllowance(Request $request)
    {
        $employee_id =  $request->get('employee_id');
        $allowance_id =  $request->get('earn_deduct_id');
        $delete =  $this->deny($employee_id, $allowance_id);
        return response()->json(["data" => $delete]);
    }


    public function getAllowance($id)
    {

        try {
            $amount = 0.0;
            $amount = OtherEarningDeduction::find($id)->formula;
            $responseBody = $this->responseBody(true, "getAllowance", "allowance", $amount);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "getAllowance", "error", "sampath");
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
