<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Leave;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\LeaveType;
use Illuminate\Support\Facades\DB;



class LeaveController extends Controller
{
    /**
     * save
     * This function is used to save new leave employee to database.
     * @param request This is the paramter to save function
     * @return Json This returns as response.
     */
    public function save(Request $request)
    {

        try {

            //$file = $request->file('imgFile');

            $leave = new Leave();
            $leave->employee_id = $request->get('txtEmployeeID');;
            $leave->employee_name = $request->get('txtEmpName');
            $leave->date = $request->get('dteDate');
            //$leave->photo_parth = $this->fileUpload($file);
            $leave->from = $request->get('dteFrom');
            $leave->to = $request->get('dteTo');
            $leave->day_count = $request->get('dayCount');
            $leave->reason = $request->get('txtReason');
            $leave->leave_type_id = $request->get('selcType');
            $leave->status = false;
            $save = $leave->save();


            if ($save) {
                $responseBody = $this->responseBody(true, "Leave", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allLeave
     * This function is used to search all leave records from the database.
     * @return Json This returns as response.
     */
    public function allLeave()
    {

        try {
            $leave =  Leave::orderBy('employee_id')->get();
            $responseBody = $this->responseBody(true, "Leave", "all", $leave);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function leaveCount($employee_id, $id, $year)
    {

        try {
            $query = "SELECT IF('" . $year . "' = hr_att_employee_leaves.`year`, ROUND(((hr_att_leave_types.days_per_year / 12) * (IF(hr_att_employee_leaves.`month` > 1,(12 - hr_att_employee_leaves.`month`),12))),0),hr_att_leave_types.days_per_year) AS allocated
            FROM hr_att_leave_types
            INNER JOIN hr_att_employee_leaves ON hr_att_leave_types.leave_type_id = hr_att_employee_leaves.leave_type_id
            WHERE hr_att_employee_leaves.employee_id = '" . $employee_id . "' AND hr_att_leave_types.leave_type_id = '" . $id . "'";
            $result = DB::select($query);
            $leave_count = 0;
            foreach ($result as $leave) {
                $leave_count =  $leave->allocated;
            }
            $responseBody = $this->responseBody(true, "Leave", "count", $leave_count);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function employeeLeaveCount($employee_id, $year, $leave_type_id)
    {

        try {
            $query = "SELECT DISTINCT (hr_att_employee_leaves.count- (SELECT COUNT(*) FROM hr_leaves WHERE hr_leaves.employee_id = '" . $employee_id . "' AND YEAR(hr_leaves.date)='" . $year . "' AND hr_leaves.leave_type_id = hr_att_leave_types.leave_type_id)) AS balance 
            FROM hr_att_leave_types INNER JOIN hr_att_employee_leaves ON hr_att_leave_types.leave_type_id = hr_att_employee_leaves.leave_type_id
            INNER JOIN hr_leaves ON hr_att_employee_leaves.leave_type_id = hr_leaves.leave_type_id AND hr_att_employee_leaves.employee_id = hr_leaves.employee_id
            WHERE hr_leaves.employee_id = '" . $employee_id . "' AND hr_att_leave_types.leave_type_id = '" . $leave_type_id . "'";

            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "Leave", "count", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function getDayCount($dateFrom, $dateTo)
    {

        $day1 = juliantojd(explode('-', $dateFrom)[1], explode('-', $dateFrom)[2], explode('-', $dateFrom)[0]);
        $day2 = juliantojd(explode('-', $dateTo)[1], explode('-', $dateTo)[2], explode('-', $dateTo)[0]);
        $count = ($day2 - $day1) + 1;
        return response()->json(["data" => $count]);
    }



    /**
     * delete
     * This function is used to delete leave from leave id.
     * @return Json This returns as response.
     */
    public function delete($id)
    {
        try {
            $leave = Leave::find($id);
            $delete = $leave->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "Leave", "deleted", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * leaveType
     * This function is used to search leave type from leave id.
     * @return Json This returns as response.
     */
    public function LeaveType($id)
    {
        try {
            $leavetype = DB::select("SELECT * from hr_att_leave_types WHERE leave_type_id = " . $id . " or leave_type_id = '1'");
            $responseBody = $this->responseBody(true, "Leave", "collection", $leavetype);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * searchName
     * This function is used to search employee name from employee id.
     * @return Json This returns as response.
     */
    public function searchName()
    {
        $data = Employee::all();
        $searchAray = [];
        for ($j = 0; $j < count($data); $j++) {
            array_push($searchAray, [
                "img" => "",
                "id" => $data[$j]['employee_id'],
                "value" => $data[$j]['name_withinitial'],
            ]);
        }
        return response()->json($searchAray);
    }


    public function allEmployeeID()
    {
        $data = Employee::all();
        $searchAray = [];
        for ($j = 0; $j < count($data); $j++) {
            array_push($searchAray, [
                "img" => "",
                "id" => $data[$j]['employee_id'],
                "value" => $data[$j]['employee_id'],
            ]);
        }
        return response()->json($searchAray);
    }


    public function employee($id)
    {
        $employee = Employee::find($id);
        return response()->json($employee);
    }



    public function getName($employee_id)
    {
        $data = Employee::find($employee_id);
        return response()->json($data);
    }






    /**
     * settings
     * This function is used to search settings records from the database.
     * @return Json This returns as response.
     */
    public function settings()
    {

        try {

            $leavetype = LeaveType::all();
            $result = [
                "LeaveType" => $leavetype,
            ];
            $responseBody = $this->responseBody(true, "Settings", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }

    /**
     * leave
     * This function is used to search leave from leave id.
     * @return Json This returns as response.
     */
    public function leave($id)
    {

        try {
            $leave = Leave::find($id);
            $leave_type_id = $leave->leave_type_id;
            $leave_type = DB::table('hr_att_leave_types')->where('leave_type_id', '=', $leave_type_id)->first();

            $settings = [
                "leave_type" => $leave_type->leave_type,
            ];

            $responseBody = $this->responseBody(true, "Leave", "all", ["leave" => $leave, "settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * update
     * This function is used to update leave.
     * @param request This is the paramter to update function
     * @return Json This returns as response.
     */
    public function update(Request $request)
    {

        try {

            $id = $request->get('hidUserID');
            $leave = Leave::find($id);
            $leave->employee_id = $request->get('txtEmployeeID');
            $leave->employee_name = $request->get('txtEmpName');
            $leave->date = $request->get('dteDate');
            $leave->from = $request->get('dteFrom');
            $leave->to = $request->get('dteTo');
            $leave->reason = $request->get('txtReason');
            $leave->leave_type_id = $request->get('selcType');
            $save = $leave->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Leave", "updated", "");
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * confirmed
     * This function is used to confirm leave.
     * @param request This is the paramter to update function
     * @return Json This returns as response.
     */
    public function confirmed($id, $user_id)
    {

        try {

            $leave = Leave::find($id);
            $leave->status = 1;
            $leave->approved_by = $user_id;
            $save = $leave->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Leave", "confirm", "");
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * confirmed
     * This function is used to confirm leave.
     * @param request This is the paramter to update function
     * @return Json This returns as response.
     */
    public function reject($id)
    {

        try {

            $leave = Leave::find($id);
            $leave->status = 3;
            $save = $leave->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Leave", "reject", "");
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function employeeLeaveData($year, $id)
    {

        try {
            $query = "SELECT hr_att_leave_types.leave_type,hr_att_employee_leaves.count AS allocated,
            (SELECT COALESCE(SUM(hr_leaves.day_count),0) FROM hr_leaves WHERE hr_leaves.employee_id = '" . $id . "' AND YEAR(hr_leaves.date)='" . $year . "' AND hr_leaves.leave_type_id = hr_att_leave_types.leave_type_id) AS used,
            (0) AS unlimited,
            (hr_att_employee_leaves.count - (SELECT COALESCE(SUM(hr_leaves.day_count),0) FROM hr_leaves WHERE hr_leaves.employee_id = '" . $id . "' AND YEAR(hr_leaves.date)='" . $year . "' AND hr_leaves.leave_type_id = hr_att_leave_types.leave_type_id)) AS balance
            FROM hr_att_leave_types INNER JOIN hr_att_employee_leaves ON hr_att_leave_types.leave_type_id = hr_att_employee_leaves.leave_type_id
            INNER JOIN hr_leaves ON hr_att_employee_leaves.leave_type_id = hr_leaves.leave_type_id AND hr_att_employee_leaves.employee_id = hr_leaves.employee_id
            WHERE hr_leaves.employee_id = '" . $id . "' GROUP BY hr_att_leave_types.leave_type_id";

            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "Leave", "count", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }
}
