<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Recruitment;

class RecruitmentController extends Controller
{
    /**
     * save
     * This function is used to save new recruitment to database.
     * @param request This is the paramter to save function
     * @return Json This returns as response.
     */
    public function save(Request $request)
    {

        try {

            $recruitment = new Recruitment();
            $recruitment->designation_id = $request->get('selcDesignation');
            $recruitment->department_id = $request->get('selcDepartment');
            $recruitment->job_role = $request->get('txtJobRole');
            $recruitment->no_of_vacant = $request->get('txtVacancies');
            $recruitment->post_date = $request->get('dtePost');
            $recruitment->expire_date = $request->get('dteExpire');
            $recruitment->age_from = $request->get('txtAgeFrom');
            $recruitment->age_to = $request->get('txtTo');
            $recruitment->education_qualification = $request->get('txtEducation');
            $recruitment->experience = $request->get('txtExperience');
            $recruitment->remarks = $request->get('txtRemarks');
            $save = $recruitment->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Recruitment", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Recruitment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * allRecruitment
     * This function is used to search all recruitment records from the database.
     * @return Json This returns as response.
     */
    public function allRecriutment()
    {

        try {
            $recruitment =  Recruitment::orderBy('job_role')->get();
            $responseBody = $this->responseBody(true, "Recruitment", "all", $recruitment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    /**
     * settings
     * This function is used to search settings records from the database.
     * @return Json This returns as response.
     */
    public function settings()
    {

        try {
           
            $department = SettingsController::allEnableSettings("Department");
            $designation = SettingsController::allEnableSettings("Designation");

            $result = [
                "Department" => $department,
                "Designation" => $designation,
            ];
            $responseBody = $this->responseBody(true, "Settings", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }


    /**
     * recruitment
     * This function is used to search recruitment from recruitment id.
     * @return Json This returns as response.
     */
    public function recruitment($id)
    {

        try {
            $recruitment = Recruitment::find($id);
            $designation = SettingsController::getSettingsFromID('Designation', $recruitment->designation_id);
            $department = SettingsController::getSettingsFromID('Department', $recruitment->department_id);


            $settings = [
                "designation" => $designation->designation,
                "department" => $department->department,
            ];

            $responseBody = $this->responseBody(true, "Recruitment", "all", ["recruitment_request" => $recruitment, "settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * delete
     * This function is used to delete recruitment from recruitment id.
     * @return Json This returns as response.
     */
    public function delete($id)
    {
        try {
            $recruitment = Recruitment::find($id);
            $delete = $recruitment->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "Recruitment", "deleted", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * update
     * This function is used to update recruitment.
     * @param request This is the paramter to update function
     * @return Json This returns as response.
     */
    public function update(Request $request)
    {

        try {

            $id = $request->get('hidUserID');
            $recruitment = Recruitment::find($id);
            $recruitment->designation_id = $request->get('selcDesignation');
            $recruitment->department_id = $request->get('selcDepartment');
            $recruitment->job_role = $request->get('txtJobRole');
            $recruitment->no_of_vacant = $request->get('txtVacancies');
            $recruitment->post_date = $request->get('dtePost');
            $recruitment->expire_date = $request->get('dteExpire');
            $recruitment->age_from = $request->get('txtAgeFrom');
            $recruitment->age_to = $request->get('txtTo');
            $recruitment->education_qualification = $request->get('txtEducation');
            $recruitment->experience = $request->get('txtExperience');
            $recruitment->remarks = $request->get('txtRemarks');
            $save = $recruitment->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Recruitment", "updated", "");
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }
}
