<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\Team;

class TeamController extends Controller
{
    //
    public function allEmployeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function save(Request $request)
    {
        try {
            $team = new Team();
            $team->leader_id = $request->get('leaderID');
            $team->team_name = $request->get('team');
            $team->status = true;
            $save = $team->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Team", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "Team", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function update(Request $request, $id)
    {
        try {
            $team = Team::find($id);
            $team->leader_id = $request->get('leaderID');
            $team->team_name = $request->get('team');
            $update = $team->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Team", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "Team", "updated", $update);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function delete($id)
    {
        try {

            $assigned = $this->isAssigned($id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Team", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned team, terminate this function
            }
            $employee_team = Team::find($id);
            $delete = $employee_team->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Team", "deleted", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function disable(Request $request, $id)
    {

        try {
            $assigned = $this->isAssigned($id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Team", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned team, terminate this function
            }
            $category = Team::find($id);
            $category->status = $request->get('status');
            $disable = $category->save();
            if ($disable) {
                $responseBody = $this->responseBody(true, "Team", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "Team", "updated", $disable);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function allTeams()
    {
        try {
            $query = "SELECT
            hr_teams.`team_id` AS team_id,
            hr_teams.`leader_id` AS leader_id,
            hr_teams.`team_name` AS team_name,
            hr_teams.`status` AS status,
            hr_employees.`name_withinitial` AS leader
       FROM
            `hr_employees` hr_employees INNER JOIN `hr_teams` hr_teams ON hr_employees.`employee_id` = hr_teams.`leader_id`";
            $teams = DB::select($query);
            $responseBody = $this->responseBody(true, "Team", "all", $teams);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function team($id)
    {
        try {
            $query = "SELECT
            hr_teams.`team_id` AS team_id,
            hr_teams.`leader_id` AS leader_id,
            hr_teams.`team_name` AS team_name,
            hr_employees.`name_withinitial` AS leader,
            hr_employees.`employee_id` AS leader_id
       FROM
            `hr_employees` hr_employees INNER JOIN `hr_teams` hr_teams ON hr_employees.`employee_id` = hr_teams.`leader_id` WHERE hr_teams.`team_id` = '" . $id . "'";
            $team = DB::select($query)[0];
            $responseBody = $this->responseBody(true, "Team", "all", $team);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function isAssigned($id)
    {

        $setting = DB::table('hr_teams')->where('team_id', $id)->first();
        if ($setting) {
            return false;
        }
        return false;
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
