
var processEmployees = undefined;
var processIndex = 0;
$(document).ready(function () {


    getProcessEmployees();
    $('input[name="fromDate_Calculation"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="toDate_Calculation"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('#employeeDiv_Calculation').hide();
    allEmployees_Calculation();
    isMonthEndPeocess_AttendaceCalculation();


    $('#cmbProcessType_Calculation').on('change', function () {

        var args = $(this).val();
        processType_Calculation(args);
    });

    $('#txtFromDate_Calculation').on('change', function () {
        isMonthEndPeocess_AttendaceCalculation();
    });

    $('#txtToDate_Calculation').on('change', function () {
        isMonthEndPeocess_AttendaceCalculation();
    });


    $('#btnProccess_Calculation').on('click', function () {

        if ($('#cmbProcessType_Calculation').val() == "All") {
            proccess_Calculation(100);
        } else {
            proccess_Calculation_Individual(100);

        }

    });


});




function getProcessEmployees() {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceProcess/getProcessEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                processEmployees = response.data.result;
                $('#att_cal_process').attr('max', response.data.result.length);
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}





function allEmployees_Calculation() {

    $.ajax({
        type: "GET",
        url: "/hr/attendanceProcess/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var employees = response.data.result;
                $('#txtEmployee_Calculation').setData(employees);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function processType_Calculation(args) {

    if (args == "All") {
        $('#employeeDiv_Calculation').hide();
        $('#att_cal_process').show();
        $('#lbl_att_ca_process').show();
    } else if (args == "Employee") {
        $('#employeeDiv_Calculation').show();
        $('#att_cal_process').hide();
        $('#lbl_att_ca_process').hide();
    }
}



function setSelectedOption_Calculation(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



function proccess_Calculation(status) {

    $('#att_cal_process').val(0);
    var employee = processEmployees[processIndex]['employee_id'];
    if (employee != undefined) {

        var fromDate = new Date($('#txtFromDate_Calculation').val()).toISOString().slice(0, 10);
        var toDate = new Date($('#txtToDate_Calculation').val()).toISOString().slice(0, 10);
        var url = "/hr/attendanceCalculationAll/" + employee + "/" + fromDate + "/" + toDate;


        if (status == 100) {

            var emp_id = "";
            var name = "";
            $.ajax({
                type: "GET",
                url: url,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 0,
                beforeSend: function () {
                    $('#lbl_att_ca_process').text("Employee : " + emp_id + " - " + name + "(processing..)");
                    $('#btnProccess_Calculation').prop("disabled", true);
                    document.getElementById('btnProccess_Calculation').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                },
                success: function (response) {
                    console.log(response);
                    emp_id = response.employee.id;
                    name = response.employee.name;
                    proccess_Calculation(response.status);
                    $('#att_cal_process').val(processIndex++);
                    var presentage = parseFloat((100 / processEmployees.length) * processIndex).toFixed(2);
                    $('#lbl_att_ca_process').text("Employee : " + emp_id + " - " + name + "(" + presentage + "%)");
                    if (presentage == 100) {
                        processIndex = 0;
                        $('#btnProccess_Calculation').text('Process');
                        $('#btnProccess_Calculation').prop("disabled", false);
                        $('#lbl_att_ca_process').text("Attendance Process calculation : " + presentage + "%");
                        showSuccessMessage('Attendance Process completed successfully...!');
                        processEmployees = undefined;
                    }

                },
                error: function (error) {
                    console.log(error);
                    showErrorMessage();
                },
                complete: function () {

                    //$('#lbl_att_ca_process').text("Employee : "+emp_id+" - "+name+"(completed..!)");
                    //$('#btnProccess_Calculation').text('Process');
                    //$('#btnProccess_Calculation').prop("disabled", false);
                }

            });
        }
    }
}






function proccess_Calculation_Individual(status) {

    $('#att_cal_process').val(0);

    var fromDate = new Date($('#txtFromDate_Calculation').val()).toISOString().slice(0, 10);
    var toDate = new Date($('#txtToDate_Calculation').val()).toISOString().slice(0, 10);
    var id = $('#txtEmployee_Calculation').optionID();
    var url = "/hr/attendanceCalculationEmployee/" + id + "/" + fromDate + "/" + toDate;


    if (status == 100) {

        var emp_id = "";
        var name = "";
        $.ajax({
            type: "GET",
            url: url,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 0,
            beforeSend: function () {
                $('#lbl_att_ca_process').text("Employee : " + emp_id + " - " + name + "(processing..)");
                $('#btnProccess_Calculation').prop("disabled", true);
                document.getElementById('btnProccess_Calculation').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                showSuccessMessage('Attendance Process completed successfully...!');

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {
                $('#btnProccess_Calculation').text('Process');
                $('#btnProccess_Calculation').prop("disabled", false);
            }

        });
    }

}




function isMonthEndPeocess_AttendaceCalculation() {
    $.ajax({
        type: "GET",
        url: '/hr/salaryData/isMonthEndProcess',
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var month_end_year = response.data.result.year;
                var month_end_month = response.data.result.month;

                var from_year = $('#txtFromDate_Calculation').val().split('-')[0];
                var from_month = $('#txtFromDate_Calculation').val().split('-')[1];

                var to_year = $('#txtToDate_Calculation').val().split('-')[0];
                var to_month = $('#txtToDate_Calculation').val().split('-')[1];

                if ((parseInt(from_year) >= parseInt(month_end_year) && parseInt(from_month) >= parseInt(month_end_month)) && (parseInt(to_year) >= parseInt(month_end_year) && parseInt(to_month) >= parseInt(month_end_month))) {
                    $('#btnProccess_Calculation').prop("disabled", false);
                } else {
                    $('#btnProccess_Calculation').prop("disabled", true);
                }



            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}