
var settings_name = "";

$(document).ready(function () {

    $('#tblEmployeeAllowance').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name" },
            { "data": "leaveType" },
            { "data": "leaveCount" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 120, targets: 0 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
        ],
    });

    $('#btnApplyAllEmployee').prop("disabled", true);
    $('#btnRemoveAllEmployee').prop("disabled", true);

    allSettings();
});

function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeLeave/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcLeaveType", settings.leaveType);
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);
                $('#auto-comp1').setData(settings.employee);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            $('#selcSection').trigger('change');
        }

    });
}



function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}



$('#selcSection').change(function (event) {


    if (event.target.value == "") {
        return;
    }
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeLeave/subSection/" + event.target.value,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
});






function applyLeaveType(settings, input) {


    var _token = $("input[name='_token']").val();

    var data = new FormData();
    data.append("leave_id", $('#selcLeaveType').val());
    data.append("id", $('#' + input).val());
    data.append("_token", _token);

    $.ajax({
        type: "POST",
        url: "/hr/attendanceEmployeeLeave/" + settings,
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Leave type has been saved successfully...");

                getLeaveType(settings);
                //resetInputs();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });

}




function applyLeaveByEmployeeID() {

    var _token = $("input[name='_token']").val();

    var data = new FormData();
    data.append("leave_id", $('#selcLeaveType').val());
    data.append("id", $('#auto-comp1').optionID());
    data.append("month", $('#selcLeaveMonth').val());
    data.append("_token", _token);

    $.ajax({
        type: "POST",
        url: "/hr/attendanceEmployeeLeave/byEmployeeId",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Leave has been saved successfully...");

                getLeaveType("employee");
                //resetInputs();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });

}










function applyLeaveAllEmployee() {

    var _token = $("input[name='_token']").val();

    var data = new FormData();
    data.append("leave_id", $('#selcLeaveType').val());
    data.append("month", $('#selcLeaveMonth').val());
    data.append("_token", _token);

    $.ajax({
        type: "POST",
        url: "/hr/attendanceEmployeeLeave/allEmployee",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Leave has been saved successfully...");

                getLeaveType("allemployee");
                resetInputs();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });

}








function getLeaveType(settings) {

    settings_name = settings;
    setTitles(settings);
    allLeaveType();

}



function setTitles(settings) {
    if (settings == "category") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by category"
        $('.card-header').text(title);
    } else if (settings == "site") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by site"
        $('.card-header').text(title);
    } else if (settings == "section") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by section"
        $('.card-header').text(title);
    } else if (settings == "subsection") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by subsection"
        $('.card-header').text(title);
    } else if (settings == "department") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by department"
        $('.card-header').text(title);
    } else if (settings == "company") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by company"
        $('.card-header').text(title);
    } else if (settings == "employee") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by employee"
        $('.card-header').text(title);
    } else if (settings == "allemployee") {
        var title = "Leave type : " + $('#selcLeaveType option:selected').text() + ", Filterd by all employee"
        $('.card-header').text(title);
        if ($('#chkAllEmployee').is(":checked")) {
            $('#btnApplyAllEmployee').prop("disabled", false);
            $('#btnRemoveAllEmployee').prop("disabled", false);
        } else {
            $('#btnApplyAllEmployee').prop("disabled", true);
            $('#btnRemoveAllEmployee').prop("disabled", true);
        }
    }
}


function allLeaveType() {

    var settings_id = 0;
    var leave_type_id = $('#selcLeaveType').val();
    setTitles(settings_name);

    if (settings_name == "category") {
        settings_id = $('#selcCategory').val();
    } else if (settings_name == "site") {
        settings_id = $('#selcSite').val();
    } else if (settings_name == "department") {
        settings_id = $('#selcDepartment').val();
    } else if (settings_name == "section") {
        settings_id = $('#selcSection').val();
    } else if (settings_name == "subsection") {
        settings_id = $('#selcSubsection').val();
    } else if (settings_name == "company") {
        settings_id = $('#selcCompany').val();
    } else if (settings_name == "employee") {
        settings_id = $('#auto-comp1').optionID();
    } else if (settings_name == "allemployee") {
        settings_id = null;
    }

    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeLeave/" + settings_name,
        data: {
            _token: $('input[name=_token]').val(),
            "settings_id": settings_id,
            "leave_type_id": leave_type_id,
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                loadLeaveType(response.data.result);
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}






function loadLeaveType(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['id'];
        var employee_id = result[i]['employee_id'];
        var leave_id = result[i]['leave_type_id'];
        var name = result[i]['name_withinitial'];
        var leave_type = result[i]['leave_type'];
        var count = result[i]['days_per_year'];
        var string_employee_id = "'" + employee_id + "'";
        var string_leave_id = "'" + leave_id + "'";
        var string_id = "'" + id + "'";
        var txtid = "txtLeaveCount" + id;
        data.push({
            "employee_id": employee_id,
            "name": name,
            "leaveType": leave_type,
            "leaveCount": '<input id="' + txtid + '" type="text" class="form-control" oninput="updateLeaveCount(' + string_id + ',' + string_leave_id + ')" value="' + count + '">',
            "delete": '<button class="btn btn-danger" onclick="deleteEmployeeLeave(' + string_employee_id + ',' + string_leave_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'
        });
    }

    var table = $('#tblEmployeeAllowance').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.delete').visible(false);




    if (remove_permission == 1) {
        table.columns('.delete').visible(true);
    }

}






function deleteEmployeeLeave(employee_id, leave_id) {

    $.ajax({
        type: "DELETE",
        url: "/hr/attendanceEmployeeLeave/delete",
        data: {
            _token: $('input[name=_token]').val(),
            "employee_id": employee_id,
            "leave_id": leave_id,
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Leave has been deleted successfully...");

                allLeaveType();
                //resetInputs();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });
}






function removeLeave(settings, input) {

    var settings_id = "";
    if (settings == "employee") {
        settings_id = $('#' + input).optionID();
    } else {
        settings_id = $('#' + input).val();
    }

    $.ajax({
        type: "DELETE",
        url: "/hr/attendanceEmployeeLeave/remove/" + settings,
        data: {
            _token: $('input[name=_token]').val(),
            "settings_id": settings_id,
            "leave_id": $('#selcLeaveType').val(),
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Leave has been deleted successfully...");

                allLeaveType();
                resetInputs();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });
}






function resetInputs() {
    $('#chkAllEmployee').prop('checked', false);
    $('#btnApplyAllEmployee').prop("disabled", true);
    $('#btnRemoveAllEmployee').prop("disabled", true);
}


function updateLeaveCount(id, leave_type_id) {

    var count = $('#txtLeaveCount' + id).val();
    if (isExcededCount(leave_type_id, count)) {
        showWarningMessage('Maximum leave count exceded.');
        return;
    }


    $.ajax({
        type: "POST",
        url: "/hr/attendanceEmployeeLeave/updateLeaveCount",
        data: { "id": id, "count": count },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Leave has been updated successfully...");
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}


function isExcededCount(leave_type_id, count) {
    var bool = false;
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeLeave/isExcededCount/" + leave_type_id + "/" + count,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        async: false,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                bool = response.data.result;
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
    return bool;
}



/**
* setSelectedOption
* This function is used to set selected option to the select tag.
*/
function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}




function autoCompleteSelectedOption(parent, args) {


}