
loadEmployee_ID();
loadEmployee_Name();
var employee_id = null;


/**
* loadEmployee_ID
* This function is used to load allemplyee id 
*/
function loadEmployee_ID() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeSchedule/allEmployeeId',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp1").setData(response.data.result);


            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* loadEmployee_Name
* This function is used to load allemplyee name 
*/
function loadEmployee_Name() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeSchedule/allEmployeeName',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp2").setData(response.data.result);
                //$("#auto-comp3").setData(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}











function autoCompleteSelectedOption(parent, args) {

    loadEmployee(args.id);
    clearCalander();
    getScheduleByEmployee(args.id);

}







function loadEmployee(id) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeSchedule/employee/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var employee = response.data.result;
                $('#imgEmployee').attr("src", employee.photo_parth);
                employee_id = employee.employee_id;
                $('#auto-comp1').val(employee.employee_id);
                $('#auto-comp2').val(employee.name_withinitial);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





function getScheduleByEmployee(id) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeSchedule/employeeSchedule/' + id,
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                createSchedule(response.data.result);
                getHolidays();

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function getScheduleByEmployeeDateRange(employee_id, start, end) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeSchedule/employeeScheduleDateRange/' + employee_id,
        data: {
            "start": start,
            "end": end,
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                createSchedule(response.data.result);
                getHolidays();

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





function getHolidays() {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeSchedule/employeeHolidays',
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                createHoliday(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function createSchedule(result) {

    var schedule_arr = [];
    if (result.length == 0) {
        return;
    }

    var date = result[0].schedule_date_from;
    var arr = date.split("-");
    var day = 0;
    if (arr.length == 3) {
        day = parseInt(arr[2]);
    }

    var schedule = [];
    for (i = 0; i < result.length; i++) {
        var next_date = result[i].schedule_date_from;
        var next_day = parseInt(next_date.split("-")[2]);
        if (day == next_day) {
            schedule.push({ "shift_id": result[i].shift_id, "shift": result[i].shift_name, "date": result[i].schedule_date_from, "in_time": result[i].in_time, "out_time": result[i].out_time });

        } else {
            schedule_arr.push(schedule);
            day = next_day;
            schedule = [];
            schedule.push({ "shift_id": result[i].shift_id, "shift": result[i].shift_name, "date": result[i].schedule_date_from, "in_time": result[i].in_time, "out_time": result[i].out_time });

        }
        day++;

    }
    schedule_arr.push(schedule);

    for (i = 0; i < schedule_arr.length; i++) {
        
        var end_date = new Date(schedule_arr[i][schedule_arr[i].length - 1].date);
        end_date.setDate(end_date.getDate() + 1);
        var start = schedule_arr[i][0].date;
        var end = end_date.getFullYear() + "-" + (((end_date.getMonth() + 1) > 9 ? '' : '0') + (end_date.getMonth() + 1)) + "-" + ((end_date.getDate() > 9 ? '' : '0') + end_date.getDate());
        var in_time = schedule_arr[i][0].in_time;
        var out_time = schedule_arr[i][0].out_time;
        var shift_id = schedule_arr[i][0].shift_id;
        addShedule(shift_id, schedule_arr[i][0].shift, start, end, in_time, out_time);
    }
    //console.log(schedule_arr);
    createCalendar();

}








function createHoliday(result) {

    console.log(result);
    if (result.length == 0) {
        return;
    }


    for (i = 0; i < result.length; i++) {
        var date = result[i].holyday_date;
        var holiday = result[i].holyday_type;
        addHoliday('', holiday, date, date, '00:00', '00:00');
    }
    
    createCalendar();

}







var start = moment().subtract(29, 'days');
var end = moment();

function cb(start, end) {
    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    var start_date = new Date(start);
    var end_date = new Date(end);

    var str_start = start_date.getFullYear() + "-" + (start_date.getMonth() + 1) + "-" + start_date.getDate();
    var str_end = end_date.getFullYear() + "-" + (end_date.getMonth() + 1) + "-" + end_date.getDate();

    clearCalander();
    getScheduleByEmployeeDateRange(employee_id, str_start, str_end);

}

$('#dashboard-daterangepicker').daterangepicker({
    startDate: start,
    endDate: end,
    opens: $('body').hasClass('rtl') ? 'right' : 'left',
    ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
}, cb);

cb(start, end);





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
