
var holiday_id = null;



$(document).ready(function () {

    $('#tblHoliday').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "date" },
            { "data": "type" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 150, targets: 0 },
            { width: 20, targets: 2 },
            { width: 20, targets: 3 },
            { width: 20, targets: 4 },
        ],
    });
    /**
     * datepicker
     * This is jquery foe datepicker .
     */
    $('input[name="dteDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });





    $('#btnAction').click(function () {
        var event = $('#btnAction').text();
        if (event == 'Save') {
            save();
        } else if (event == 'Update') {
            update();
        } else if (event == 'Reset') {
            reset();
        }
    });

    allSite();
    allHolidayType();
    allHolidays();

});


function allSite() {
    $.ajax({
        type: "GET",
        url: '/hr/holiday/allSite',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                appendOptionSite(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function allHolidayType() {

    $.ajax({
        type: "GET",
        url: '/hr/holiday/allHolidayType',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                appendOptionHolidayType(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}


function appendOptionSite(result) {

    $('#selcSite').empty();
    for (i = 0; i < result.length; i++) {
        $('#selcSite').append('<option value="' + result[i].site_id + '">' + result[i].site + '</option>')
    }
}


function appendOptionHolidayType(result) {

    $('#selcHolidayType').empty();
    for (i = 0; i < result.length; i++) {
        $('#selcHolidayType').append('<option value="' + result[i].holyday_type_id + '">' + result[i].holyday_type + '</option>')
    }
}




function save() {
    var date = $('#dteDate').val();
    if (isHoliday(date)) {
        showWarningMessage(date + ' allready marked as a holiday');
    } else {
        var form = $('#formHoliday').get(0);
        var data = new FormData(form);

        $.ajax({
            type: "POST",
            url: '/hr/atdHoliday',
            data: data,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {

                    showSuccessMessage("Holiday has been saved successfully...");
                    allHolidays();


                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }
}



function allHolidays() {
    $.ajax({
        type: "GET",
        url: '/hr/holiday/allHoliday',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                appendTableRow(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






function update() {

    if (holiday_id != null) {

        $.ajax({
            type: 'PUT',
            url: '/hr/atdHoliday/updateHoliday/' + holiday_id,
            data: $('#formHoliday').serialize(),
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {
                    showSuccessMessage("Holiday has been updated successfully...");
                    holiday_id = null;
                    allHolidays();
                    reset();
                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error.message);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }
}






/**
* loadTable
* This function is used to data set on the tables.
* @param result This is the paramter for table result
*/
function appendTableRow(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['id'];
        var date = result[i]['holyday_date'];
        var type = result[i]['holyday_type'];
        var string_id = "'" + id + "'";


        data.push({
            "date": date,
            "type": type,
            "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
            "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
        });
    }

    var table = $('#tblHoliday').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.view').visible(false);
    table.columns('.delete').visible(false);




    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (view_permission == 1) {
        table.columns('.view').visible(true);
    }

    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }

}






function edit(id) {
    getHoliday(id);
    $('#btnAction').text('Update');
}



function view(id) {
    getHoliday(id);
    $('#btnAction').text('Reset');
}



function getHoliday(id) {
    $.ajax({
        type: "GET",
        url: '/hr/holiday/getHoliday/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                $('#dteDate').val(result.holyday_date);
                setSelectedOption('selcHolidayType', result.holyday_type_id);
                setSelectedOption('selcSite', result.site_id);
                $('#txtRemark').text(result.remarks);
                holiday_id = id;


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function _delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/holiday/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Holiday has been deleted successfully...")
                allHolidays();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function reset() {

    $('#formHoliday').trigger("reset");
    $('#txtRemark').text('');
    $('#btnAction').text('Save');
}




function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function isHoliday(date) {

    var bool = false;
    $.ajax({
        type: "GET",
        url: '/hr/holiday/isHoliday/' + date,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);


            bool = response.data.result;



        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
    return bool;
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}