
$(document).ready(function () {


    $('#tblCategory').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "category_id" },
            { "data": "category" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
            { "data": "status", className: "disable" },
        ],
        columnDefs: [
            { width: 120, targets: 0 },
            { width: 50, targets: 2 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 }
        ],
    });

    allCategories();

    $('#txtOvertime1').on('input', function () {
        var rate = parseFloat($(this).val());
        if (rate > 0) {
            $('#txtFixedOtRate1').val(0);
        }
    });


    $('#txtFixedOtRate1').on('input', function () {
        var rate = parseFloat($(this).val());
        if (rate > 0) {
            $('#txtOvertime1').val(0);
        }
    });

    $('#txtOvertime2').on('input', function () {
        var rate = parseFloat($(this).val());
        if (rate > 0) {
            $('#txtFixedOtRate2').val(0);
        }
    });


    $('#txtFixedOtRate2').on('input', function () {
        var rate = parseFloat($(this).val());
        if (rate > 0) {
            $('#txtOvertime2').val(0);
        }
    });


    $('#txtOvertime3').on('input', function () {
        var rate = parseFloat($(this).val());
        if (rate > 0) {
            $('#txtFixedOtRate3').val(0);
        }
    });


    $('#txtFixedOtRate3').on('input', function () {
        var rate = parseFloat($(this).val());
        if (rate > 0) {
            $('#txtOvertime3').val(0);
        }
    });

});




function showModal() {
    resetCategory();
    $('#categoryAddModal').modal('toggle');
}

function hideModal() {
    $('#categoryAddModal').modal('hide');
}


function resetCategory() {
    $('#categoryForm').trigger("reset");
    $('#btnAction').show();
    $('#btnAction').text('Save');
}


function actionBtn() {

    var text = $('#btnAction').text();
    if (text == "Save") {
        save();
    } else if (text == "Update") {
        update();
    }
}



/**
* save
* This function is used to save employee salary.
*/
function save() {

    var form = $('#categoryForm').get(0);
    var data = new FormData(form);

    $.ajax({
        type: "POST",
        url: "/hr/category",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success == true) {
                showSuccessMessage("Category has been saved successfully...");
                hideModal();
                allCategories();
            } else {
                showErrorMessage();

            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function allCategories() {
    $.ajax({
        type: "GET",
        url: "/hr/category/allCategories",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['category_id'];
                    var name = response.data.result[i]['category'];
                    var string_id = "'" + id + "'";
                    var status = "";
                    if (response.data.result[i]['status'] == 1) {
                        status = "checked";
                    }
                    data.push({
                        "category_id": generateID(id),
                        "category": name,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                        "status": '<label class="switch"><input type="checkbox" id="1" onchange="disable(event,' + string_id + ')" ' + status + '><span class="slider round"></span></label>'
                    });
                }

                var table = $('#tblCategory').DataTable();
                table.clear();
                table.rows.add(data).draw();
                table.columns('.edit').visible(false);
                table.columns('.view').visible(false);
                table.columns('.delete').visible(false);
                table.columns('.disable').visible(false);



                if (edit_permission == 1) {
                    table.columns('.edit').visible(true);
                }

                if (view_permission == 1) {
                    table.columns('.view').visible(true);
                }

                if (delete_permission == 1) {
                    table.columns('.delete').visible(true);
                }

                if (disable_permission == 1) {
                    table.columns('.disable').visible(true);
                }



            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}




var update_id = 0;
function edit(id) {
    $.ajax({
        type: "GET",
        url: '/hr/category/category/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showModal();
                update_id = response.data.result.category_id;
                $('#txtCategory').val(response.data.result.category);
                setSelectedOption('selcCalculate', response.data.result.wage_calculate);
                setSelectedOption('selcPayment', response.data.result.wage_pay_type);
                $('#txtWorkMonth').val(response.data.result.work_days_month);
                $('#txtWorkDay').val(response.data.result.work_hour_day);
                $('#txtOvertime1').val(response.data.result.ot_rate1);
                $('#txtOvertime2').val(response.data.result.ot_rate2);
                $('#txtOvertime3').val(response.data.result.ot_rate3);
                $('#txtFixedOtRate1').val(response.data.result.fixed_ot_rate1);
                $('#txtFixedOtRate2').val(response.data.result.fixed_ot_rate2);
                $('#txtFixedOtRate3').val(response.data.result.fixed_ot_rate3);
                $('#txtEpfEmployer').val(response.data.result.epf_employer);
                $('#txtEpfEmployee').val(response.data.result.epf_employee);
                $('#txtEtfEmployee').val(response.data.result.etf_employee);
                $('#txtAllowance1').val(response.data.result.budget_allowance1);
                $('#txtAllowance2').val(response.data.result.budget_allowance2);
                $('#txtFineRate').val(response.data.result.fine_rate);
                $('#btnAction').text('Update');

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function view(id) {
    $.ajax({
        type: "GET",
        url: '/hr/category/category/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showModal();
                $('#txtCategory').val(response.data.result.category);
                setSelectedOption('selcCalculate', response.data.result.wage_calculate);
                setSelectedOption('selcPayment', response.data.result.wage_pay_type);
                $('#txtWorkMonth').val(response.data.result.work_days_month);
                $('#txtWorkDay').val(response.data.result.work_hour_day);
                $('#txtOvertime1').val(response.data.result.ot_rate1);
                $('#txtOvertime2').val(response.data.result.ot_rate2);
                $('#txtOvertime3').val(response.data.result.ot_rate3);
                $('#txtFixedOtRate1').val(response.data.result.fixed_ot_rate1);
                $('#txtFixedOtRate2').val(response.data.result.fixed_ot_rate2);
                $('#txtFixedOtRate3').val(response.data.result.fixed_ot_rate3);
                $('#txtEpfEmployer').val(response.data.result.epf_employer);
                $('#txtEpfEmployee').val(response.data.result.epf_employee);
                $('#txtEtfEmployee').val(response.data.result.etf_employee);
                $('#txtAllowance1').val(response.data.result.budget_allowance1);
                $('#txtAllowance2').val(response.data.result.budget_allowance2);
                $('#txtFineRate').val(response.data.result.fine_rate);
                $('#btnAction').hide();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function update() {
    $.ajax({
        type: 'PUT',
        url: '/hr/category/update/' + update_id,
        data: $('#categoryForm').serialize(),
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Category has been updated successfully...");
                hideModal();
                resetCategory();
                allCategories();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function _delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/category/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Category has been deleted successfully...");
                allCategories();
            } else {

                var msg = response.data.message;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Category has been assigned...!");
                    allCategories();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}



function disable(event, id) {
    var status = 0;
    if (event.target.checked) {
        status = 1;
    }

    $.ajax({
        type: 'PUT',
        url: '/hr/category/disable/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": status
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("Category has been disabled successfully...");
                allCategories();
            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Category has been assigned...!");
                    allCategories();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}







/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}

