var settings_name = "";

$(document).ready(function () {
    $('#tblEmployeeAllowance').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name" },
            { "data": "allowance" },
            { "data": "amount",className: "amount" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 120, targets: 0 },
            { width: 80, targets: 3 },
            { width: 50, targets: 4 },
        ],
    });
    allSettings();


    $('#selcAllowance').on('change', function () {

        $.ajax({
            type: "GET",
            url: "/hr/employeeAllowance/getAllowance/" + $(this).val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {
                    $('#txtAmount').val(response.data.result);

                } else {
                    showErrorMessage();
                }
            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {

            }

        });

    });
});




function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/employeeAllowance/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                console.log(settings.allowance);
                appendOption("selcAllowance", settings.allowance);
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);
                appendOption("selcTeam", settings.team);
                $('#auto-comp1').setData(settings.employee);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            $('#selcSection').trigger('change');
        }

    });
}



function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}




$('#selcSection').change(function (event) {


    if (event.target.value == "") {
        return;
    }
    $.ajax({
        type: "GET",
        url: "/hr/employeeAllowance/subSection/" + event.target.value,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
});








function applyAllowance(settings, input) {

    if ($('#selcAllowance').val() == null) {
        showWarningMessage('Please select the allowance...!');
        return;
    }


    if ($('#txtAmount').val() == '' || $('#txtAmount').val() == null || isNaN($('#txtAmount').val())) {
        showWarningMessage('Invalied amount...!');
        return;
    }


    if ($('#' + input).val() == null) {
        showWarningMessage('Please select the ' + settings + '...!');
        return;
    }

    $.ajax({
        type: "GET",
        url: "/hr/employeeAllowance/" + settings + "/" + $('#selcAllowance').val() + "/" + $('#txtAmount').val(),
        data: {
            _token: $('input[name=_token]').val(),
            "id": $('#' + input).val()
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Allowance has been saved successfully...");

                getEmployeeAllowance(settings);
                //resetInputs();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });

}






function applyAllowanceByEmployeeID() {

    if ($('#selcAllowance').val() == null) {
        showWarningMessage('Please select the allowance...!');
        return;
    }


    if ($('#txtAmount').val() == '' || $('#txtAmount').val() == null || isNaN($('#txtAmount').val())) {
        showWarningMessage('Invalied amount...!');
        return;
    }


    if ($('#auto-comp1').optionID() == "") {
        showWarningMessage('Please select the employee...!');
        return;
    }

    $.ajax({
        type: "GET",
        url: "/hr/employeeAllowance/byEmployeeId/" + $('#selcAllowance').val() + "/" + $('#txtAmount').val(),
        data: {
            _token: $('input[name=_token]').val(),
            "id": $('#auto-comp1').optionID(),
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Allowance has been saved successfully...");

                getEmployeeAllowance("employee");
                //resetInputs();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });

}





function getEmployeeAllowance(settings) {

    settings_name = settings;
    setTitles(settings);
    allEmployeesAllowance();

}



function setTitles(settings) {
    if (settings == "category") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by category"
        $('.card-header').text(title);
    } else if (settings == "site") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by site"
        $('.card-header').text(title);
    } else if (settings == "section") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by section"
        $('.card-header').text(title);
    } else if (settings == "subsection") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by subsection"
        $('.card-header').text(title);
    } else if (settings == "department") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by department"
        $('.card-header').text(title);
    } else if (settings == "company") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by company"
        $('.card-header').text(title);
    } else if (settings == "team") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by team"
        $('.card-header').text(title);
    } else if (settings == "employee") {
        var title = "Allowance type : " + $('#selcAllowance option:selected').text() + ", Filterd by employee"
        $('.card-header').text(title);
    }
}




function allEmployeesAllowance() {

    var settings_id = 0;
    var allowance_id = $('#selcAllowance').val();
    setTitles(settings_name);

    if (settings_name == "category") {
        settings_id = $('#selcCategory').val();
    } else if (settings_name == "site") {
        settings_id = $('#selcSite').val();
    } else if (settings_name == "department") {
        settings_id = $('#selcDepartment').val();
    } else if (settings_name == "section") {
        settings_id = $('#selcSection').val();
    } else if (settings_name == "subsection") {
        settings_id = $('#selcSubsection').val();
    } else if (settings_name == "company") {
        settings_id = $('#selcCompany').val();
    } else if (settings_name == "team") {
        settings_id = $('#selcTeam').val();
    } else if (settings_name == "employee") {
        settings_id = $('#auto-comp1').optionID();
    }

    $.ajax({
        type: "GET",
        url: "/hr/employeeAllowance/" + settings_name,
        data: {
            _token: $('input[name=_token]').val(),
            "settings_id": settings_id,
            "allowance_id": allowance_id,
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                loadAllowance(response.data.result);
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function loadAllowance(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var employee_id = result[i]['employees_employee_id'];
        var earn_deduct_id = result[i]['earn_deduct_id'];
        var name = result[i]['employees_name_withinitial'];
        var allowance = result[i]['other_earning_deduction_title'];
        var amount = result[i]['amount'];
        var string_employee_id = "'" + employee_id + "'";
        var string_earn_deduct_id = "'" + earn_deduct_id + "'";
        data.push({
            "employee_id": employee_id,
            "name": name,
            "allowance": allowance,
            "amount": parseFloat(amount).toFixed(2),
            "delete": '<button class="btn btn-danger" onclick="deleteEmployeeAllowance(' + string_employee_id + ',' + string_earn_deduct_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'
        });
    }

    var table = $('#tblEmployeeAllowance').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.delete').visible(false);



    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }



}





function denyAllowance(settings, input) {

    if ($('#selcAllowance').val() == null) {
        showWarningMessage('Please select the allowance...!');
        return;
    }


    if ($('#txtAmount').val() == '' || $('#txtAmount').val() == null || isNaN($('#txtAmount').val())) {
        showWarningMessage('Invalied amount...!');
        return;
    }


    if (settings == 'employee') {
        if ($('#auto-comp1').optionID() == "") {
            showWarningMessage('Please select the employee...!');
            return;
        }
    } else {
        if ($('#' + input).val() == null) {
            showWarningMessage('Please select the ' + settings + '...!');
            return;
        }
    }

    $settings_id = "";
    if (settings == "employee") {
        $settings_id = $('#' + input).optionID();
    } else {
        $settings_id = $('#' + input).val();
    }

    $.ajax({
        type: "DELETE",
        url: "/hr/employeeAllowance/deny/" + settings,
        data: {
            _token: $('input[name=_token]').val(),
            "settings_id": $settings_id,
            "allowance_id": $('#selcAllowance').val(),
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Allowance has been deleted successfully...");

                allEmployeesAllowance();
                resetInputs();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });
}




function resetInputs() {
    setSelectedOption('selcAllowance', 'disabled');
    setSelectedOption('selcCategory', 'disabled');
    setSelectedOption('selcSite', 'disabled');
    setSelectedOption('selcDepartment', 'disabled');
    setSelectedOption('selcSection', 'disabled');
    setSelectedOption('selcSubsection', 'disabled');
    setSelectedOption('selcCompany', 'disabled');
    $('#txtAmount').val(0);
    $('#auto-comp1').val('');
    $('#auto-comp1').attr('data-id', '');
}



function deleteEmployeeAllowance(employee_id, earn_deduct_id) {

    $.ajax({
        type: "DELETE",
        url: "/hr/employeeAllowance/delete",
        data: {
            _token: $('input[name=_token]').val(),
            "employee_id": employee_id,
            "earn_deduct_id": earn_deduct_id,
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Allowance has been deleted successfully...");

                allEmployeesAllowance();
                //resetInputs();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });
}



/**
* setSelectedOption
* This function is used to set selected option to the select tag.
*/
function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}




function autoCompleteSelectedOption(parent, args) {

}