$(document).ready(function () {

    $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "nic" },
            { "data": "name_full" },
            { "data": "designation" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view"  },
            { "data": "delete", className: "delete"  },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 }
        ],
    });

    getEmployee(1);

});



function getEmployee(page_id) {

    $.ajax({
        type: "GET",
        url: "/hr/employee/allEmployee",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['employee_id'];
                    var nic = response.data.result[i]['nic'];
                    var name = response.data.result[i]['name_withinitial']
                    var designation = response.data.result[i]['designation'];
                    var string_id = "'" + id + "'";


                    data.push({
                        "employee_id": id,
                        "nic":nic,
                        "name_full": name,
                        "designation": designation,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
                table.columns('.edit').visible(false);
                table.columns('.view').visible(false);
                table.columns('.delete').visible(false);



                if (edit_permission == 1) {
                    table.columns('.edit').visible(true);
                }

                if (view_permission == 1) {
                    table.columns('.view').visible(true);
                }

                if (delete_permission == 1) {
                    table.columns('.delete').visible(true);
                }


            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}


function edit(id) {
    location.href = "/hr/employee?" + id;

}


function view(id) {
    location.href = "/hr/employee?" + id + "&view";
}


function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/employee/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Employee has been deleted successfully...")
                getEmployee(1);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}