
/**
 * java script -salartSheet
 *
 * @author  Sampath Perera
 * @since   2020-11-27
 */


 var salary_id = null;

loadEmployee_ID();
loadEmployee_Name();
appendYear();
appendMonth();
setDeduct_year_month();
edit_and_view();


$(document).ready(function () {
    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="txtTranDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });
    var date = new Date();
    $("#txtTranDate").val(date.getFullYear()+"-"+(date.getMonth()+1)+"-"+date.getDate());




    $('#btnAction').click(function () {

        var event = $('#btnAction').text();
        if (event == "Save") {
            save();
        }else if(event == "Update"){
            update();
        }
    });
});




/**
* loadEmployee_ID
* This function is used to load allemplyee id 
*/
function loadEmployee_ID() {


    $.ajax({
        type: "GET",
        url: '/hr/salaryAdvance/allEmployeeId',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp1").setData(response.data.result);


            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* loadEmployee_Name
* This function is used to load allemplyee name 
*/
function loadEmployee_Name() {


    $.ajax({
        type: "GET",
        url: '/hr/salaryAdvance/allEmployeeName',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp2").setData(response.data.result);
                //$("#auto-comp3").setData(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





function loadEmployee(employee_id) {

    $.ajax({
        type: "GET",
        url: '/hr/salaryAdvance/employee/' + employee_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var employee = response.data.result;
                $('#imgEmployee').attr("src", employee.photo_parth);
                $('#employee_id').val(employee.employee_id);
                $('#auto-comp1').val(employee.employee_id);
                $('#auto-comp2').val(employee.name_withinitial);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}







function loadEmployeeFromList(id) {

    $.ajax({
        type: "GET",
        url: '/hr/salaryAdvance/employeeFromList/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var advance = response.data.result;
                var employee = advance.employee;
                $('#imgEmployee').attr("src", employee.photo_parth);
                $('#employee_id').val(employee.employee_id);
                $('#auto-comp1').val(employee.employee_id);
                $('#auto-comp2').val(employee.name_withinitial);
                var amount = parseFloat(advance.amount);
                $('#txtAmount').val(amount.toFixed(2));
                $('#txtTranDate').val(advance.tran_date);
                setSelectedOption('selcDeductYear', advance.deduct_year);
                setSelectedOption('selcDeductMonth', advance.deduct_month);
                $('#btnAction').text('Update');

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






//This function is override from autocomplete.min.js
function autoCompleteSelectedOption(input, data) {

    loadEmployee(data.id);

}

//This function is override from numeric.js
function numericInputTrigger() {

}





function appendYear() {

    var date = new Date();
    var year = date.getFullYear() + 1;

    $('#selcDeductYear').empty();
    //$('#selcYear').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 2015; i <= year; i++) {
        $('#selcDeductYear').append('<option value="' + i + '">' + i + '</option>');
    }

}


function appendMonth() {
    var month = {
        1: "January",
        2: "February",
        3: "March",
        4: "April",
        5: "May",
        6: "June",
        7: "July",
        8: "August",
        9: "September",
        10: "October",
        11: "November",
        12: "December",
    };


    $('#selcDeductMonth').empty();
    //$('#selcMonth').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 1; i <= 12; i++) {
        $('#selcDeductMonth').append('<option value="' + i + '">' + month[i] + '</option>');
    }


}




function setDeduct_year_month() {

    var date = new Date();
    var year = date.getFullYear();
    var mon = date.getMonth() + 2;
    if (mon > 12) {
        mon = 1;
        year += 1;
    }
    let month_element = document.getElementById('selcDeductMonth');
    month_element.value = mon;

    let year_element = document.getElementById('selcDeductYear');
    year_element.value = year;


}






function save() {

    var form = $('#salaryAdvanceForm').get(0);
    var data = new FormData(form);

    $.ajax({
        type: "POST",
        url: "/hr/salaryAdvance",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Salary Advance has been saved successfully...");
                resetSalaryAdvance();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });


}




function edit_and_view() {

    if (window.location.search.length > 0) {
        $('#btnReset').show();
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('&');

        if (param.length == 2) {
            if (param[1] != "view") {
                location.href = "/hr/salaryAdvanceList";
            }
            $('#btnAction').hide();
            $('#btnDelete').hide();
        } else {
            $('#btnAction').show();
        }

        var id = param[0];
        salary_id = id;
        loadEmployeeFromList(id);
    } else {
        $('#btnReset').hide();
        $('#btnDelete').hide();
        $('#btnAction').show();
    }
}





function update() {

    if (salary_id != null) {
        $.ajax({
            type: 'PUT',
            url: '/hr/salaryAdvance/update/' + salary_id,
            data: $('#salaryAdvanceForm').serialize(),
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {
                    showSuccessMessage("Salary advance has been updated successfully...");
                    salary_id = null;
                    location.href = "/hr/salaryAdvanceList";
                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error.message);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }
}






function _delete() {



    swal({
        title: "Are you sure?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
        .then((willDelete) => {
            if (willDelete) {
                do_delete();
            }
        });
}





function do_delete() {

    if (salary_id != null) {
        $.ajax({
            type: 'DELETE',
            url: '/hr/salaryAdvance/deleteSalaryDataFromID/' + salary_id,
            data: {
                _token: $('input[name=_token]').val()
            },
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                if (response.data.success) {
                    showSuccessMessage("Salary advance has been deleted successfully...");
                    location.href = "/hr/salaryAdvanceList";

                } else {
                    showErrorMessage();
                }
            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }

}





function resetSalaryAdvance() {
    $('#salaryAdvanceForm').trigger("reset");
    $("#imgEmployee").attr("src", "/images/employee.jpg");
    appendYear();
    appendMonth();
    $('#btnReset').hide();
    $('#btnDelete').hide();
    $('#btnAction').text("Save");
    $('#btnAction').show();
    var date = new Date();
    $("#txtTranDate").val(date.getFullYear()+"-"+(date.getMonth()+1)+"-"+date.getDate());
}




function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
    $('#' + id).trigger('change');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}



