var att_id_arr = [];
var user_id = uid;// uid get from session
$(document).ready(function () {

    var datepicker = $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY/MM/DD',
        }

    });


    datepicker.bind("change", function () {
        $('#chekApproval').prop('checked', false);
        var date = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);
        loadAttendance(user_id, date);
    });




    $('#chekApproval').on('change', function () {
        if (this.checked) {

            $('.btnApprov').attr("class", "btn btn-primary btnApprov");
            $('.btnApprov').html('<i class="fa fa-check" aria-hidden="true"></i>');

        } else {

            $('.btnApprov').attr("class", "btn btn-danger btnApprov");
            $('.btnApprov').html('<i class="fa fa-times" aria-hidden="true"></i>');
        }
    });



});


$(document).on('click', 'button', function () {
    if ($(this).attr("class") == "btn btn-danger btnApprov") {
        $(this).attr("class", "btn btn-primary btnApprov");
        $(this).html('<i class="fa fa-check" aria-hidden="true"></i>');
    } else if ($(this).attr("class") == "btn btn-primary btnApprov") {
        $(this).attr("class", "btn btn-danger btnApprov");
        $(this).html('<i class="fa fa-times" aria-hidden="true"></i>');
    }
});







/**
* loadAttendance att_time
* This function is used to load employee attendance
*/
function loadAttendance(id, date) {


    $.ajax({
        type: "GET",
        url: '/hr/supervisorApproval/employeeAttendance/' + id + '/' + date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                appendTableRow(result);
                $('.row_btn').hide();
            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



function autoCompleteSelectedOption(input, data) {
    loadEmployee(data.id);
    $('#tblRawData').empty();
    var startDate = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);
    var endDate = new Date($('#txtDateTo').val()).toISOString().slice(0, 10);
    loadAttendance(data.id, startDate, endDate);
}



function appendTableRow(result) {

    var tbody = "";
    for (i = 0; i < result.length; i++) {
        var id = result[i]['att_id'];
        var name = result[i]['name_withinitial'];
        var intime = result[i]['InTime'];
        var outtime = result[i]['OutTime'];
        var remark = result[i]['remark'];
        var approval = result[i]['approval'];
        var string_id = "btn" + id;

        if (intime == null) {
            intime = '';
        }

        if (outtime == null) {
            outtime = '';
        }

        if (remark == 'null' || remark == null) {
            remark = '';
        }
        att_id_arr.push(id);


        var row = "<tr>";
        row += '<td class="id" id="' + id + '">' + id + '</td>';
        row += '<td>' + name + '</td>';
        row += '<td>' + intime + '</td>';
        row += '<td>' + outtime + '</td>';
        if (approval_permission == 1) {
            if (approval == 1) {
                $('#chekApproval').prop('checked', true);
                row += '<td class="approval"><button class="btn btn-primary btnApprov" id="' + string_id + '"><i class="fa fa-check" aria-hidden="true"></i></button></td>';
            } else {
                row += '<td class="approval"><button class="btn btn-danger btnApprov" id="' + string_id + '"><i class="fa fa-times" aria-hidden="true"></i></button></td>';
            }
        } else {
            $('.approval').hide();
        }
        row += '<td><input type="text" class="form-control" id="txtRemark' + id + '" value="' + remark + '"></td>';
        tbody += row;


    }

    $('#att_timeBody').empty();
    $('#att_timeBody').append(tbody);






}












function approval() {

    var tbl = [];
    for (i = 0; i < att_id_arr.length; i++) {

        var id = att_id_arr[i];
        var approval = false;
        console.log('#' + id);
        if ($('#btn' + id).attr("class") == "btn btn-primary btnApprov") {
            approval = true;
        }

        var remark = $('#txtRemark' + id).val();
        var row = [id, approval, remark];
        tbl.push(JSON.stringify(row));
    }

    var date = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);

    var data = new FormData();
    data.append("_token", $("input[name='_token']").val());
    data.append("user_id", user_id);
    data.append("data", JSON.stringify(tbl));
    data.append("date", date);

    $.ajax({
        type: "POST",
        url: '/hr/supervisorApproval/approval',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                showSuccessMessage("Attendance has been approved successfully...");
            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}